/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xml.eventconf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.xml.eventconf.EventMatcher;
import org.opennms.netmgt.xml.eventconf.EventMatchers;
import org.opennms.netmgt.xml.eventconf.Maskelement;
import org.opennms.netmgt.xml.eventconf.Varbind;

@XmlRootElement(name="mask")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="eventconf.xsd")
@XmlType(propOrder={"m_maskElements", "m_varbinds"})
public class Mask
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement(name="maskelement", required=true)
    private List<Maskelement> m_maskElements = new ArrayList<Maskelement>();
    @XmlElement(name="varbind")
    private List<Varbind> m_varbinds = new ArrayList<Varbind>();

    public List<Maskelement> getMaskelements() {
        return this.m_maskElements;
    }

    public void setMaskelements(List<Maskelement> elements) {
        if (this.m_maskElements == elements) {
            return;
        }
        this.m_maskElements.clear();
        if (elements != null) {
            this.m_maskElements.addAll(elements);
        }
    }

    public void addMaskelement(Maskelement element) {
        this.m_maskElements.add(element);
    }

    public boolean removeMaskelement(Maskelement element) {
        return this.m_maskElements.remove(element);
    }

    public List<Varbind> getVarbinds() {
        return this.m_varbinds;
    }

    public void setVarbinds(List<Varbind> varbinds) {
        if (this.m_varbinds == varbinds) {
            return;
        }
        this.m_varbinds.clear();
        if (varbinds != null) {
            this.m_varbinds.addAll(varbinds);
        }
    }

    public void addVarbind(Varbind varbind) {
        this.m_varbinds.add(varbind);
    }

    public boolean removeVarbind(Varbind varbind) {
        return this.m_varbinds.remove(varbind);
    }

    public int hashCode() {
        return Objects.hash(this.m_maskElements, this.m_varbinds);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Mask) {
            Mask that = (Mask)obj;
            return Objects.equals(this.m_maskElements, that.m_maskElements) && Objects.equals(this.m_varbinds, that.m_varbinds);
        }
        return false;
    }

    public EventMatcher constructMatcher() {
        EventMatcher[] matchers = new EventMatcher[this.m_maskElements.size() + this.m_varbinds.size()];
        int index = 0;
        for (Maskelement maskElement : this.m_maskElements) {
            matchers[index] = maskElement.constructMatcher();
            ++index;
        }
        for (Varbind varbind : this.m_varbinds) {
            matchers[index] = varbind.constructMatcher();
            ++index;
        }
        return EventMatchers.and(matchers);
    }

    public Maskelement getMaskElement(String mename) {
        for (Maskelement element : this.m_maskElements) {
            if (!mename.equals(element.getMename())) continue;
            return element;
        }
        return null;
    }

    public List<String> getMaskElementValues(String mename) {
        Maskelement element = this.getMaskElement(mename);
        return element == null ? null : element.getMevalues();
    }
}

