/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.telemetry.adapters.registry.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import org.opennms.core.soa.lookup.ServiceLookup;
import org.opennms.core.soa.lookup.ServiceLookupBuilder;
import org.opennms.features.telemetry.adapters.registry.api.TelemetryAdapterRegistry;
import org.opennms.netmgt.telemetry.adapters.api.Adapter;
import org.opennms.netmgt.telemetry.adapters.api.AdapterFactory;
import org.opennms.netmgt.telemetry.config.api.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;

public class TelemetryAdapterRegistryImpl
implements TelemetryAdapterRegistry,
ServiceLookup<String, Void> {
    private static final Logger LOG = LoggerFactory.getLogger(TelemetryAdapterRegistry.class);
    private static final ServiceLoader<AdapterFactory> s_adapterFactoryLoader = ServiceLoader.load(AdapterFactory.class);
    protected static final String TYPE = "type";
    private final Map<String, AdapterFactoryRegistration> m_adapterFactoryByClassName = new HashMap<String, AdapterFactoryRegistration>();
    private final ServiceLookup<String, Void> delegate;
    @Autowired
    private ApplicationContext applicationContext;

    public TelemetryAdapterRegistryImpl() {
        this(ServiceLookupBuilder.GRACE_PERIOD_MS, ServiceLookupBuilder.WAIT_PERIOD_MS, ServiceLookupBuilder.LOOKUP_DELAY_MS);
    }

    public TelemetryAdapterRegistryImpl(long gracePeriodMs, long waitPeriodMs, long lookupDelayMs) {
        this.delegate = new ServiceLookupBuilder((ServiceLookup)new ServiceLookup<String, Void>(){

            public <T> T lookup(String criteria, Void filter) {
                return (T)TelemetryAdapterRegistryImpl.this.m_adapterFactoryByClassName.get(criteria);
            }
        }).blocking(gracePeriodMs, lookupDelayMs, waitPeriodMs).build();
        for (AdapterFactory adapterFactory : s_adapterFactoryLoader) {
            String className = adapterFactory.getAdapterClass().getCanonicalName();
            this.m_adapterFactoryByClassName.put(className, new AdapterFactoryRegistration(className, adapterFactory, true));
        }
    }

    public synchronized void onBind(AdapterFactory adapterFactory, Map properties) {
        LOG.debug("Bind called with {}: {}", (Object)adapterFactory, (Object)properties);
        if (adapterFactory != null) {
            String className = TelemetryAdapterRegistryImpl.getClassName(properties);
            if (className == null) {
                LOG.warn("Unable to determine the class name for AdapterFactory: {}, with properties: {}. The adapter will not be registered.", (Object)adapterFactory, (Object)properties);
                return;
            }
            this.m_adapterFactoryByClassName.put(className, new AdapterFactoryRegistration(className, adapterFactory, false));
        }
    }

    public synchronized void onUnbind(AdapterFactory adapterFactory, Map properties) {
        LOG.debug("Unbind called with {}: {}", (Object)adapterFactory, (Object)properties);
        if (adapterFactory != null) {
            String className = TelemetryAdapterRegistryImpl.getClassName(properties);
            if (className == null) {
                LOG.warn("Unable to determine the class name for AdapterFactory: {}, with properties: {}. The adapter will not be unregistered.", (Object)adapterFactory, (Object)properties);
                return;
            }
            this.m_adapterFactoryByClassName.remove(className);
        }
    }

    @Override
    public Adapter getAdapter(String className, Protocol protocol, Map<String, String> properties) {
        AdapterFactoryRegistration registration = (AdapterFactoryRegistration)this.delegate.lookup((Object)className, null);
        if (registration != null) {
            Adapter adapter = registration.getAdapterFactory().createAdapter(protocol, properties);
            if (registration.shouldAutowire()) {
                AutowireCapableBeanFactory beanFactory = this.applicationContext.getAutowireCapableBeanFactory();
                beanFactory.autowireBean((Object)adapter);
                beanFactory.initializeBean((Object)adapter, "adapter");
            }
            return adapter;
        }
        return null;
    }

    private static String getClassName(Map<?, ?> properties) {
        Object type = properties.get(TYPE);
        if (type != null && type instanceof String) {
            return (String)type;
        }
        return null;
    }

    public <T> T lookup(String criteria, Void filter) {
        return (T)this.delegate.lookup((Object)criteria, (Object)filter);
    }

    private static class AdapterFactoryRegistration {
        private final String clazz;
        private final AdapterFactory factory;
        private final boolean autowire;

        public AdapterFactoryRegistration(String clazz, AdapterFactory factory, boolean autowire) {
            this.clazz = Objects.requireNonNull(clazz);
            this.factory = Objects.requireNonNull(factory);
            this.autowire = autowire;
        }

        public String getAdapterClass() {
            return this.clazz;
        }

        public AdapterFactory getAdapterFactory() {
            return this.factory;
        }

        public boolean shouldAutowire() {
            return this.autowire;
        }
    }
}

