/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.function.Supplier;
import org.hibernate.FlushMode;
import org.hibernate.SessionFactory;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionOperations;

public class DefaultSessionUtils
implements SessionUtils {
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    private TransactionOperations transactionOperations;

    @Override
    public <V> V withTransaction(Supplier<V> supplier) {
        return (V)this.transactionOperations.execute(status -> supplier.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> V withManualFlush(Supplier<V> supplier) {
        FlushMode flushMode = this.sessionFactory.getCurrentSession().getFlushMode();
        try {
            this.sessionFactory.getCurrentSession().setFlushMode(FlushMode.MANUAL);
            V v = supplier.get();
            return v;
        }
        finally {
            this.sessionFactory.getCurrentSession().setFlushMode(flushMode);
        }
    }
}

