/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml.schema.syslog;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.integration.api.xml.ConfigUtils;
import org.opennms.integration.api.xml.schema.syslog.HostaddrMatch;
import org.opennms.integration.api.xml.schema.syslog.HostnameMatch;
import org.opennms.integration.api.xml.schema.syslog.Match;
import org.opennms.integration.api.xml.schema.syslog.ParameterAssignment;
import org.opennms.integration.api.xml.schema.syslog.ProcessMatch;

@XmlRootElement(name="ueiMatch")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class UeiMatch
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement(name="facility")
    private List<String> m_facilities = new ArrayList<String>();
    @XmlElement(name="severity")
    private List<String> m_severities = new ArrayList<String>();
    @XmlElement(name="process-match")
    private ProcessMatch m_processMatch;
    @XmlElement(name="hostname-match")
    private HostnameMatch m_hostnameMatch;
    @XmlElement(name="hostaddr-match")
    private HostaddrMatch m_hostaddrMatch;
    @XmlElement(name="match", required=true)
    private Match m_match;
    @XmlElement(name="uei", required=true)
    private String m_uei;
    @XmlElement(name="parameter-assignment")
    private List<ParameterAssignment> m_parameterAssignments = new ArrayList<ParameterAssignment>();

    public List<String> getFacilities() {
        return this.m_facilities;
    }

    public void setFacilities(List<String> facilities) {
        if (facilities == this.m_facilities) {
            return;
        }
        this.m_facilities.clear();
        if (facilities != null) {
            this.m_facilities.addAll(facilities);
        }
    }

    public void addFacility(String facility) {
        this.m_facilities.add(facility);
    }

    public boolean removeFacility(String facility) {
        return this.m_facilities.remove(facility);
    }

    public List<String> getSeverities() {
        return this.m_severities;
    }

    public void setSeverities(List<String> severities) {
        if (severities == this.m_severities) {
            return;
        }
        this.m_severities.clear();
        if (severities != null) {
            this.m_severities.addAll(severities);
        }
    }

    public void addSeverity(String severity) {
        this.m_severities.add(severity);
    }

    public boolean removeSeverity(String severity) {
        return this.m_severities.remove(severity);
    }

    public Optional<ProcessMatch> getProcessMatch() {
        return Optional.ofNullable(this.m_processMatch);
    }

    public void setProcessMatch(ProcessMatch processMatch) {
        this.m_processMatch = processMatch;
    }

    public Optional<HostnameMatch> getHostnameMatch() {
        return Optional.ofNullable(this.m_hostnameMatch);
    }

    public void setHostnameMatch(HostnameMatch hostnameMatch) {
        this.m_hostnameMatch = hostnameMatch;
    }

    public Optional<HostaddrMatch> getHostaddrMatch() {
        return Optional.ofNullable(this.m_hostaddrMatch);
    }

    public void setHostaddrMatch(HostaddrMatch hostaddrMatch) {
        this.m_hostaddrMatch = hostaddrMatch;
    }

    public Match getMatch() {
        return this.m_match;
    }

    public void setMatch(Match match) {
        this.m_match = ConfigUtils.assertNotNull(match, "match");
    }

    public String getUei() {
        return this.m_uei;
    }

    public void setUei(String uei) {
        this.m_uei = ConfigUtils.assertNotEmpty(uei, "uei");
    }

    public List<ParameterAssignment> getParameterAssignments() {
        return this.m_parameterAssignments;
    }

    public void setParameterAssignments(List<ParameterAssignment> parameterAssignments) {
        if (parameterAssignments == this.m_parameterAssignments) {
            return;
        }
        this.m_parameterAssignments.clear();
        if (parameterAssignments != null) {
            this.m_parameterAssignments.addAll(parameterAssignments);
        }
    }

    public void addParameterAssignment(ParameterAssignment parameterAssignment) {
        this.m_parameterAssignments.add(parameterAssignment);
    }

    public boolean removeParameterAssignment(ParameterAssignment parameterAssignment) {
        return this.m_parameterAssignments.remove(parameterAssignment);
    }

    public int hashCode() {
        return Objects.hash(this.m_facilities, this.m_severities, this.m_processMatch, this.m_hostnameMatch, this.m_hostaddrMatch, this.m_match, this.m_uei, this.m_parameterAssignments);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UeiMatch) {
            UeiMatch that = (UeiMatch)obj;
            return Objects.equals(this.m_facilities, that.m_facilities) && Objects.equals(this.m_severities, that.m_severities) && Objects.equals(this.m_processMatch, that.m_processMatch) && Objects.equals(this.m_hostnameMatch, that.m_hostnameMatch) && Objects.equals(this.m_hostaddrMatch, that.m_hostaddrMatch) && Objects.equals(this.m_match, that.m_match) && Objects.equals(this.m_uei, that.m_uei) && Objects.equals(this.m_parameterAssignments, that.m_parameterAssignments);
        }
        return false;
    }
}

