/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml.schema.eventconf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.opennms.integration.api.xml.ConfigUtils;
import org.opennms.integration.api.xml.schema.eventconf.AlarmData;
import org.opennms.integration.api.xml.schema.eventconf.Autoacknowledge;
import org.opennms.integration.api.xml.schema.eventconf.Autoaction;
import org.opennms.integration.api.xml.schema.eventconf.Correlation;
import org.opennms.integration.api.xml.schema.eventconf.Filter;
import org.opennms.integration.api.xml.schema.eventconf.Forward;
import org.opennms.integration.api.xml.schema.eventconf.Logmsg;
import org.opennms.integration.api.xml.schema.eventconf.Mask;
import org.opennms.integration.api.xml.schema.eventconf.Operaction;
import org.opennms.integration.api.xml.schema.eventconf.Parameter;
import org.opennms.integration.api.xml.schema.eventconf.Script;
import org.opennms.integration.api.xml.schema.eventconf.Snmp;
import org.opennms.integration.api.xml.schema.eventconf.Tticket;
import org.opennms.integration.api.xml.schema.eventconf.Varbindsdecode;

@XmlRootElement(name="event")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(propOrder={})
public class Event
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlElement(name="mask", required=false)
    private Mask m_mask;
    @XmlElement(name="uei", required=true)
    private String m_uei;
    @XmlElement(name="event-label", required=true)
    private String m_eventLabel;
    @XmlElement(name="snmp", required=false)
    private Snmp m_snmp;
    @XmlElement(name="descr", required=true)
    private String m_descr;
    @XmlElement(name="logmsg", required=true)
    private Logmsg m_logmsg;
    @XmlElement(name="severity", required=true)
    private String m_severity;
    @XmlElement(name="correlation", required=false)
    private Correlation m_correlation;
    @XmlElement(name="operinstruct", required=false)
    private String m_operinstruct;
    @XmlElement(name="autoaction", required=false)
    private List<Autoaction> m_autoactions = new ArrayList<Autoaction>();
    @XmlElement(name="varbindsdecode", required=false)
    private List<Varbindsdecode> m_varbindsdecodes = new ArrayList<Varbindsdecode>();
    @XmlElement(name="parameter", required=false)
    private List<Parameter> m_parameters = new ArrayList<Parameter>();
    @XmlElement(name="operaction", required=false)
    private List<Operaction> m_operactions = new ArrayList<Operaction>();
    @XmlElement(name="autoacknowledge", required=false)
    private Autoacknowledge m_autoacknowledge;
    @XmlElement(name="loggroup", required=false)
    private List<String> m_loggroups = new ArrayList<String>();
    @XmlElement(name="tticket", required=false)
    private Tticket m_tticket;
    @XmlElement(name="forward", required=false)
    private List<Forward> m_forwards = new ArrayList<Forward>();
    @XmlElement(name="script", required=false)
    private List<Script> m_scripts = new ArrayList<Script>();
    @XmlElement(name="mouseovertext", required=false)
    private String m_mouseovertext;
    @XmlElement(name="alarm-data", required=false)
    private AlarmData m_alarmData;
    @XmlElementWrapper(name="filters", required=false)
    @XmlElement(name="filter", required=true)
    private List<Filter> m_filters;

    public Mask getMask() {
        return this.m_mask;
    }

    public void setMask(Mask mask) {
        this.m_mask = mask;
    }

    public String getUei() {
        return this.m_uei;
    }

    public void setUei(String uei) {
        this.m_uei = ConfigUtils.assertNotEmpty(uei, "uei").intern();
    }

    public String getEventLabel() {
        return this.m_eventLabel;
    }

    public void setEventLabel(String eventLabel) {
        this.m_eventLabel = ConfigUtils.assertNotEmpty(eventLabel, "event-label").intern();
    }

    public Snmp getSnmp() {
        return this.m_snmp;
    }

    public void setSnmp(Snmp snmp) {
        this.m_snmp = snmp;
    }

    public String getDescr() {
        return this.m_descr;
    }

    public void setDescr(String descr) {
        this.m_descr = ConfigUtils.normalizeAndInternString(descr);
    }

    public Logmsg getLogmsg() {
        return this.m_logmsg;
    }

    public void setLogmsg(Logmsg logmsg) {
        this.m_logmsg = ConfigUtils.assertNotNull(logmsg, "logmsg");
    }

    public String getSeverity() {
        return this.m_severity;
    }

    public void setSeverity(String severity) {
        this.m_severity = ConfigUtils.assertNotEmpty(severity, "severity").intern();
    }

    public Correlation getCorrelation() {
        return this.m_correlation;
    }

    public void setCorrelation(Correlation correlation) {
        this.m_correlation = correlation;
    }

    public String getOperinstruct() {
        return this.m_operinstruct;
    }

    public void setOperinstruct(String operinstruct) {
        this.m_operinstruct = ConfigUtils.normalizeAndInternString(operinstruct);
    }

    public List<Autoaction> getAutoactions() {
        return this.m_autoactions;
    }

    public void setAutoactions(List<Autoaction> autoactions) {
        if (this.m_autoactions == autoactions) {
            return;
        }
        this.m_autoactions.clear();
        if (autoactions != null) {
            this.m_autoactions.addAll(autoactions);
        }
    }

    public void addAutoaction(Autoaction autoaction) {
        this.m_autoactions.add(autoaction);
    }

    public boolean removeAutoaction(Autoaction autoaction) {
        return this.m_autoactions.remove(autoaction);
    }

    public List<Varbindsdecode> getVarbindsdecodes() {
        return this.m_varbindsdecodes;
    }

    public void setVarbindsdecodes(List<Varbindsdecode> decodes) {
        if (this.m_varbindsdecodes == decodes) {
            return;
        }
        this.m_varbindsdecodes.clear();
        if (decodes != null) {
            this.m_varbindsdecodes.addAll(decodes);
        }
    }

    public void addVarbindsdecode(Varbindsdecode varbindsdecode) {
        this.m_varbindsdecodes.add(varbindsdecode);
    }

    public boolean removeVarbindsdecode(Varbindsdecode decode) {
        return this.m_varbindsdecodes.remove(decode);
    }

    public List<Parameter> getParameters() {
        return this.m_parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        if (this.m_parameters == parameters) {
            return;
        }
        this.m_parameters.clear();
        if (parameters != null) {
            this.m_parameters.addAll(parameters);
        }
    }

    public void addParameter(Parameter parameter) {
        this.m_parameters.add(parameter);
    }

    public boolean removeParameter(Parameter parameter) {
        return this.m_parameters.remove(parameter);
    }

    public List<Operaction> getOperactions() {
        return this.m_operactions;
    }

    public void setOperactions(List<Operaction> operactions) {
        if (this.m_operactions == operactions) {
            return;
        }
        this.m_operactions.clear();
        if (operactions != null) {
            this.m_operactions.addAll(operactions);
        }
    }

    public void addOperaction(Operaction operaction) {
        this.m_operactions.add(operaction);
    }

    public boolean removeOperaction(Operaction operaction) {
        return this.m_operactions.remove(operaction);
    }

    public Autoacknowledge getAutoacknowledge() {
        return this.m_autoacknowledge;
    }

    public void setAutoacknowledge(Autoacknowledge autoacknowledge) {
        this.m_autoacknowledge = autoacknowledge;
    }

    public List<String> getLoggroups() {
        return this.m_loggroups;
    }

    public void setLoggroups(List<String> loggroups) {
        if (this.m_loggroups == loggroups) {
            return;
        }
        this.m_loggroups.clear();
        if (loggroups != null) {
            this.m_loggroups.addAll(loggroups);
        }
    }

    public void addLoggroup(String loggroup) {
        this.m_loggroups.add(loggroup.intern());
    }

    public boolean removeLoggroup(String loggroup) {
        return this.m_loggroups.remove(loggroup);
    }

    public Tticket getTticket() {
        return this.m_tticket;
    }

    public void setTticket(Tticket tticket) {
        this.m_tticket = tticket;
    }

    public List<Forward> getForwards() {
        return this.m_forwards;
    }

    public void setForwards(List<Forward> forwards) {
        if (this.m_forwards == forwards) {
            return;
        }
        this.m_forwards.clear();
        if (forwards != null) {
            this.m_forwards.addAll(forwards);
        }
    }

    public void addForward(Forward forward) {
        this.m_forwards.add(forward);
    }

    public boolean removeForward(Forward forward) {
        return this.m_forwards.remove(forward);
    }

    public List<Script> getScripts() {
        return this.m_scripts;
    }

    public void setScripts(List<Script> scripts) {
        if (this.m_scripts == scripts) {
            return;
        }
        this.m_scripts.clear();
        if (scripts != null) {
            this.m_scripts.addAll(scripts);
        }
    }

    public void addScript(Script script) {
        this.m_scripts.add(script);
    }

    public boolean removeScript(Script script) {
        return this.m_scripts.remove(script);
    }

    public String getMouseovertext() {
        return this.m_mouseovertext;
    }

    public void setMouseovertext(String mouseovertext) {
        this.m_mouseovertext = ConfigUtils.normalizeAndInternString(mouseovertext);
    }

    public AlarmData getAlarmData() {
        return this.m_alarmData;
    }

    public void setAlarmData(AlarmData alarmData) {
        this.m_alarmData = alarmData;
    }

    public List<Filter> getFilters() {
        return this.m_filters == null ? Collections.emptyList() : this.m_filters;
    }

    public void setFilters(List<Filter> filters) {
        if (filters == this.m_filters) {
            return;
        }
        if (filters == null) {
            this.m_filters = null;
        } else {
            this.m_filters.clear();
            this.m_filters.addAll(filters);
        }
    }

    public void addFilter(Filter filter) {
        if (this.m_filters == null) {
            this.m_filters = new ArrayList<Filter>();
        }
        this.m_filters.add(filter);
    }

    public boolean removeFilter(Filter filter) {
        if (this.m_filters == null) {
            return false;
        }
        return this.m_filters.remove(filter);
    }

    public int hashCode() {
        return Objects.hash(this.m_mask, this.m_uei, this.m_eventLabel, this.m_snmp, this.m_descr, this.m_logmsg, this.m_severity, this.m_correlation, this.m_operinstruct, this.m_autoactions, this.m_varbindsdecodes, this.m_parameters, this.m_operactions, this.m_autoacknowledge, this.m_loggroups, this.m_tticket, this.m_forwards, this.m_scripts, this.m_mouseovertext, this.m_alarmData, this.m_filters);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Event) {
            Event that = (Event)obj;
            return Objects.equals(this.m_mask, that.m_mask) && Objects.equals(this.m_uei, that.m_uei) && Objects.equals(this.m_eventLabel, that.m_eventLabel) && Objects.equals(this.m_snmp, that.m_snmp) && Objects.equals(this.m_descr, that.m_descr) && Objects.equals(this.m_logmsg, that.m_logmsg) && Objects.equals(this.m_severity, that.m_severity) && Objects.equals(this.m_correlation, that.m_correlation) && Objects.equals(this.m_operinstruct, that.m_operinstruct) && Objects.equals(this.m_autoactions, that.m_autoactions) && Objects.equals(this.m_varbindsdecodes, that.m_varbindsdecodes) && Objects.equals(this.m_parameters, that.m_parameters) && Objects.equals(this.m_operactions, that.m_operactions) && Objects.equals(this.m_autoacknowledge, that.m_autoacknowledge) && Objects.equals(this.m_loggroups, that.m_loggroups) && Objects.equals(this.m_tticket, that.m_tticket) && Objects.equals(this.m_forwards, that.m_forwards) && Objects.equals(this.m_scripts, that.m_scripts) && Objects.equals(this.m_mouseovertext, that.m_mouseovertext) && Objects.equals(this.m_alarmData, that.m_alarmData) && Objects.equals(this.m_filters, that.m_filters);
        }
        return false;
    }

    public List<String> getMaskElementValues(String mename) {
        return this.m_mask == null ? null : this.m_mask.getMaskElementValues(mename);
    }
}

