/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigUtils.class);

    public static <T> T assertNotNull(T value, String name) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("'" + name + "' cannot be null!");
        }
        return value;
    }

    public static <T> T assertNotEmpty(T value, String name) throws IllegalArgumentException {
        T check = value instanceof String ? ConfigUtils.normalizeString((String)value) : value;
        ConfigUtils.assertNotNull(check, name);
        return check;
    }

    public static String normalizeString(String s) {
        if ("".equals(s)) {
            return null;
        }
        return s;
    }

    public static String normalizeAndTrimString(String value) {
        String ret = ConfigUtils.normalizeString(value);
        if (ret == null) {
            return null;
        }
        return ret.trim();
    }

    public static String normalizeAndInternString(String value) {
        String ret = ConfigUtils.normalizeString(value);
        if (ret == null) {
            return null;
        }
        return ret.intern();
    }

    public static <T extends Number> T assertMinimumInclusive(T value, long minimum, String name) {
        if (value != null && value.longValue() < minimum) {
            throw new IllegalArgumentException("'" + name + "' must be at least " + minimum);
        }
        return value;
    }

    public static <T extends Collection<?>> T assertMinimumSize(T value, long minimum, String name) {
        if (value != null && (long)value.size() < minimum) {
            throw new IllegalArgumentException("'" + name + "' must contain at least " + minimum + " entry!");
        }
        return value;
    }

    public static <K, T> T assertOnlyContains(T value, Collection<K> in, String name) {
        if (value == null) {
            return value;
        }
        if (value instanceof String) {
            if (!in.contains(value)) {
                throw new IllegalStateException("'" + name + "': found '" + value.toString() + "' but expected one of: " + in.toString());
            }
        } else if (Collection.class.isAssignableFrom(value.getClass())) {
            Collection col = (Collection)value;
            for (Object entry : col) {
                if (in.contains(entry)) continue;
                throw new IllegalStateException("'" + name + "': found '" + entry.toString() + "' but expected one of: " + in.toString());
            }
        } else {
            LOG.warn("Unsure how to deal with value type {}", value.getClass());
        }
        return value;
    }

    public static String assertMatches(String value, Pattern pattern, String name) {
        if (value == null) {
            return value;
        }
        Matcher m = pattern.matcher(value);
        if (!m.matches()) {
            throw new IllegalStateException("'" + name + "': value '" + value + "' did no match pattern '" + pattern + "'");
        }
        return value;
    }
}

