/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.xml;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.config.syslog.SyslogMatch;
import org.opennms.integration.api.xml.ClasspathXmlLoader;
import org.opennms.integration.api.xml.schema.syslog.ParameterAssignment;
import org.opennms.integration.api.xml.schema.syslog.SyslogdConfigurationGroup;
import org.opennms.integration.api.xml.schema.syslog.UeiMatch;

public class ClasspathSyslogMatchLoader
extends ClasspathXmlLoader<SyslogdConfigurationGroup> {
    public ClasspathSyslogMatchLoader(Class<?> clazz, String ... fileNames) {
        super(clazz, SyslogdConfigurationGroup.class, "syslog", fileNames);
    }

    public List<SyslogMatch> getSyslogMatches() {
        return this.getObjects().stream().flatMap(s -> ClasspathSyslogMatchLoader.toSyslogMatches(s).stream()).collect(Collectors.toList());
    }

    private static List<SyslogMatch> toSyslogMatches(SyslogdConfigurationGroup configGroup) {
        LinkedList<SyslogMatch> syslogMatches = new LinkedList<SyslogMatch>();
        for (final UeiMatch ueiMatch : configGroup.getUeiMatches()) {
            final LinkedList<1> parameterAssignments = new LinkedList<1>();
            for (final ParameterAssignment p : ueiMatch.getParameterAssignments()) {
                parameterAssignments.add(new org.opennms.integration.api.v1.config.syslog.ParameterAssignment(){

                    public int getGroupNumber() {
                        return p.getMatchingGroup();
                    }

                    public String getParameterName() {
                        return p.getParameterName();
                    }
                });
            }
            syslogMatches.add(new SyslogMatch(){

                public int getPriority() {
                    return 0;
                }

                public String getMatchExpression() {
                    return ueiMatch.getMatch().getExpression();
                }

                public String getUei() {
                    return ueiMatch.getUei();
                }

                public List<org.opennms.integration.api.v1.config.syslog.ParameterAssignment> getParameterAssignments() {
                    return parameterAssignments;
                }
            });
        }
        return syslogMatches;
    }
}

