/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.inventory.impl.helper;

import java.io.Writer;
import org.apache.felix.inventory.impl.helper.ConfigurationWriter;

public class HtmlConfigurationWriter
extends ConfigurationWriter {
    private boolean doFilter;
    private final char[] oneChar = new char[1];

    public HtmlConfigurationWriter(Writer delegatee) {
        super(delegatee);
    }

    public void enableFilter(boolean doFilter) {
        this.doFilter = doFilter;
        if (doFilter) {
            super.write("<pre>", 0, 5);
        } else {
            super.write("</pre>", 0, 6);
        }
        super.println();
    }

    public void println() {
        if (this.doFilter) {
            this.write(10);
        } else {
            super.println();
        }
    }

    public void print(String str) {
        char[] chars = str.toCharArray();
        this.write(chars, 0, chars.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int character) {
        char[] cArray = this.oneChar;
        synchronized (this.oneChar) {
            this.oneChar[0] = (char)character;
            this.write(this.oneChar, 0, 1);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void write(char[] chars, int off, int len) {
        if (this.doFilter) {
            chars = this.escapeHtml(new String(chars, off, len)).toCharArray();
            off = 0;
            len = chars.length;
        }
        super.write(chars, off, len);
    }

    public void write(String string, int off, int len) {
        this.write(string.toCharArray(), off, len);
    }

    private String escapeHtml(String text) {
        StringBuffer sb = new StringBuffer(text.length() * 4 / 3);
        int oldch = 95;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case ' ': {
                    sb.append("&nbsp;");
                    break;
                }
                case '\n': 
                case '\r': {
                    if (oldch == 13 || oldch == 10) break;
                    sb.append("\n");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            oldch = ch;
        }
        return sb.toString();
    }
}

