/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.common.kafka;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Properties;
import org.opennms.core.ipc.common.kafka.KafkaConfigProvider;
import org.osgi.service.cm.ConfigurationAdmin;

public class OsgiKafkaConfigProvider
implements KafkaConfigProvider {
    private final String groupId;
    private final String pid;
    private final ConfigurationAdmin configAdmin;

    public OsgiKafkaConfigProvider(String groupId, String pid, ConfigurationAdmin configAdmin) {
        this.groupId = groupId;
        this.pid = pid;
        this.configAdmin = Objects.requireNonNull(configAdmin);
    }

    public OsgiKafkaConfigProvider(String pid, ConfigurationAdmin configAdmin) {
        this(null, pid, configAdmin);
    }

    @Override
    public synchronized Properties getProperties() {
        Properties kafkaConfig = new Properties();
        if (this.groupId != null) {
            kafkaConfig.put("group.id", this.groupId);
        }
        try {
            Dictionary properties = this.configAdmin.getConfiguration(this.pid).getProperties();
            if (properties != null) {
                Enumeration keys = properties.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    kafkaConfig.put(key, properties.get(key));
                }
            }
            return kafkaConfig;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot load properties", e);
        }
    }
}

