/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.net.InetAddress;
import java.util.Date;
import java.util.List;
import org.opennms.netmgt.dao.api.OspfLinkDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OspfLink;
import org.springframework.util.Assert;

public class OspfLinkDaoHibernate
extends AbstractDaoHibernate<OspfLink, Integer>
implements OspfLinkDao {
    public OspfLinkDaoHibernate() {
        super(OspfLink.class);
    }

    @Override
    public OspfLink get(OnmsNode node, InetAddress ospfRemRouterId, InetAddress ospfRemIpAddr, Integer ospfRemAddressLessIndex) {
        return (OspfLink)this.findUnique("from OspfLink as ospfLink where ospfLink.node = ? and ospfLink.ospfRemRouterId = ? and ospfLink.ospfRemIpAddr = ? and ospfLink.ospfRemAddressLessIndex = ?", node, ospfRemRouterId, ospfRemIpAddr, ospfRemAddressLessIndex);
    }

    @Override
    public OspfLink get(Integer nodeId, InetAddress ospfRemRouterId, InetAddress ospfRemIpAddr, Integer ospfRemAddressLessIndex) {
        Assert.notNull((Object)nodeId, (String)"nodeId cannot be null");
        Assert.notNull((Object)ospfRemRouterId, (String)"ospfRemRouterId cannot be null");
        Assert.notNull((Object)ospfRemIpAddr, (String)"ospfRemIpAddr cannot be null");
        Assert.notNull((Object)ospfRemAddressLessIndex, (String)"ospfRemAddressLessIndex cannot be null");
        return (OspfLink)this.findUnique("from OspfLink as ospfLink where ospfLink.node.id = ? and ospfLink.ospfRemRouterId = ? and ospfLink.ospfRemIpAddr = ? and ospfLink.ospfRemAddressLessIndex = ?", nodeId, ospfRemRouterId, ospfRemIpAddr, ospfRemAddressLessIndex);
    }

    @Override
    public List<OspfLink> findByNodeId(Integer nodeId) {
        Assert.notNull((Object)nodeId, (String)"nodeId cannot be null");
        return this.find("from OspfLink ospfLink where ospfLink.node.id = ?", nodeId);
    }

    @Override
    public void deleteByNodeIdOlderThen(Integer nodeId, Date now) {
        this.getHibernateTemplate().bulkUpdate("delete from OspfLink ospfLink where ospfLink.node.id = ? and ospfLinkLastPollTime < ?", new Object[]{nodeId, now});
    }

    @Override
    public void deleteByNodeId(Integer nodeId) {
        this.getHibernateTemplate().bulkUpdate("delete from OspfLink ospfLink where ospfLink.node.id = ? ", new Object[]{nodeId});
    }
}

