/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.alarm;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opennms.core.utils.FuzzyDateFormatter;
import org.opennms.netmgt.model.OnmsSeverity;

public class SituationSummary {
    private int situationId;
    private OnmsSeverity situationSeverity;
    private String situationLocations;
    private long affectedNodes;
    private long relatedAlarms;
    private Date minLastEventDate;

    public SituationSummary(Integer situationId, OnmsSeverity situationSeverity, String situationLocations, Long affectedNodes, Long relatedAlarms, Date minLastEventDate) {
        this.situationId = situationId;
        this.situationSeverity = situationSeverity;
        this.situationLocations = situationLocations;
        this.affectedNodes = affectedNodes;
        this.relatedAlarms = relatedAlarms;
        this.minLastEventDate = minLastEventDate;
    }

    public int getSituationId() {
        return this.situationId;
    }

    public Date getMinLastEventDate() {
        return this.minLastEventDate;
    }

    public OnmsSeverity getSituationSeverity() {
        return this.situationSeverity;
    }

    public String getSituationLocations() {
        return this.situationLocations;
    }

    public List<String> getSituationLocationList() {
        return this.situationLocations == null ? Lists.newArrayList() : Stream.of(this.situationLocations.split(", ")).collect(Collectors.toList());
    }

    public long getAffectedNodes() {
        return this.affectedNodes;
    }

    public long getRelatedAlarms() {
        return this.relatedAlarms;
    }

    public String getFuzzyTimeDown() {
        return this.minLastEventDate == null ? "N/A" : FuzzyDateFormatter.calculateDifference((Date)this.minLastEventDate, (Date)new Date());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SituationSummary that = (SituationSummary)o;
        return this.situationId == that.situationId && this.affectedNodes == that.affectedNodes && this.relatedAlarms == that.relatedAlarms && this.situationSeverity == that.situationSeverity && Objects.equals(this.situationLocations, that.situationLocations);
    }

    public int hashCode() {
        return Objects.hash(this.situationId, this.situationSeverity, this.situationLocations, this.affectedNodes, this.relatedAlarms);
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((Object)this).add("situationId", this.situationId).add("situationSeverity", (Object)this.situationSeverity).add("situationLocations", (Object)this.situationLocations).add("affectedNodes", this.affectedNodes).add("relatedAlarms", this.relatedAlarms).toString();
    }
}

