/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.soa.lookup;

import java.lang.management.ManagementFactory;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.opennms.core.soa.lookup.BlockingServiceLookup;
import org.opennms.core.soa.lookup.ServiceLookup;

public class ServiceLookupBuilder<C, F> {
    public static final long GRACE_PERIOD_MS = Long.getLong("org.opennms.core.soa.lookup.gracePeriodMs", TimeUnit.MINUTES.toMillis(5L));
    public static final long WAIT_PERIOD_MS = Long.getLong("org.opennms.core.soa.lookup.gracePeriodMs", TimeUnit.MINUTES.toMillis(1L));
    public static final long LOOKUP_DELAY_MS = Long.getLong("org.opennms.core.soa.lookup.lookupDelayMs", TimeUnit.SECONDS.toMillis(5L));
    private final ServiceLookup<C, F> serviceProvider;
    private long gracePeriodInMs;
    private long sleepTimeInMs;
    private long waitTimeMs;
    private Supplier<Long> upTimeSupplier;

    public ServiceLookupBuilder(ServiceLookup<C, F> serviceProvider) {
        this.serviceProvider = Objects.requireNonNull(serviceProvider);
    }

    public ServiceLookupBuilder blocking() {
        return this.blocking(GRACE_PERIOD_MS, LOOKUP_DELAY_MS, GRACE_PERIOD_MS);
    }

    public ServiceLookupBuilder blocking(long gracePeriodInMs, long sleepTimeInMs, long waitTimeMs) {
        return this.blocking(gracePeriodInMs, sleepTimeInMs, waitTimeMs, () -> ManagementFactory.getRuntimeMXBean().getUptime());
    }

    public ServiceLookupBuilder blocking(long gracePeriodInMs, long sleepTimeInMs, long waitTimeMs, Supplier<Long> upTimeSupplier) {
        Objects.requireNonNull(upTimeSupplier);
        this.gracePeriodInMs = gracePeriodInMs;
        this.sleepTimeInMs = sleepTimeInMs;
        this.waitTimeMs = waitTimeMs;
        this.upTimeSupplier = Objects.requireNonNull(upTimeSupplier);
        return this;
    }

    public ServiceLookup<C, F> build() {
        if (this.upTimeSupplier != null) {
            BlockingServiceLookup<C, F> lookup = new BlockingServiceLookup<C, F>(this.serviceProvider);
            lookup.setGracePeriodInMs(this.gracePeriodInMs);
            lookup.setLookupDelayMs(this.sleepTimeInMs);
            lookup.setWaitTimeMs(this.waitTimeMs);
            lookup.setUptimeSupplier(this.upTimeSupplier);
            return lookup;
        }
        return this.serviceProvider;
    }
}

