/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class IpInterfaceDaoHibernate
extends AbstractDaoHibernate<OnmsIpInterface, Integer>
implements IpInterfaceDao {
    private static final Logger LOG = LoggerFactory.getLogger(IpInterfaceDaoHibernate.class);
    String m_findByServiceTypeQuery = System.getProperty("org.opennms.dao.ipinterface.findByServiceType", "select distinct ipInterface from OnmsIpInterface as ipInterface join ipInterface.monitoredServices as monSvc where monSvc.serviceType.name = ?");

    public IpInterfaceDaoHibernate() {
        super(OnmsIpInterface.class);
    }

    @Override
    public OnmsIpInterface get(OnmsNode node, String ipAddress) {
        return (OnmsIpInterface)this.findUnique("from OnmsIpInterface as ipInterface where ipInterface.node = ? and ipInterface.ipAddress = ?", node, ipAddress);
    }

    @Override
    public List<OnmsIpInterface> findByIpAddress(String ipAddress) {
        return this.find("from OnmsIpInterface ipInterface where ipInterface.ipAddress = ?", ipAddress);
    }

    @Override
    public List<OnmsIpInterface> findByNodeId(Integer nodeId) {
        Assert.notNull((Object)nodeId, (String)"nodeId cannot be null");
        return this.find("from OnmsIpInterface ipInterface where ipInterface.node.id = ?", nodeId);
    }

    @Override
    public OnmsIpInterface findByNodeIdAndIpAddress(Integer nodeId, String ipAddress) {
        return (OnmsIpInterface)this.findUnique("select ipInterface from OnmsIpInterface as ipInterface where ipInterface.node.id = ? and ipInterface.ipAddress = ?", nodeId, ipAddress);
    }

    @Override
    public OnmsIpInterface findByForeignKeyAndIpAddress(String foreignSource, String foreignId, String ipAddress) {
        return (OnmsIpInterface)this.findUnique("select ipInterface from OnmsIpInterface as ipInterface join ipInterface.node as node where node.foreignSource = ? and node.foreignId = ? and ipInterface.ipAddress = ?", foreignSource, foreignId, ipAddress);
    }

    @Override
    public List<OnmsIpInterface> findByServiceType(String svcName) {
        return this.find(this.m_findByServiceTypeQuery, svcName);
    }

    @Override
    public List<OnmsIpInterface> findHierarchyByServiceType(String svcName) {
        return this.find("select distinct ipInterface from OnmsIpInterface as ipInterface left join fetch ipInterface.node as node left join fetch node.assetRecord left join fetch ipInterface.node.snmpInterfaces as snmpIf left join fetch snmpIf.ipInterfaces join ipInterface.monitoredServices as monSvc where monSvc.serviceType.name = ?", svcName);
    }

    @Override
    public Map<InetAddress, Integer> getInterfacesForNodes() {
        HashMap<InetAddress, Integer> map = new HashMap<InetAddress, Integer>();
        List l = this.getHibernateTemplate().find("select distinct ipInterface.ipAddress, ipInterface.node.id from OnmsIpInterface as ipInterface where ipInterface.isSnmpPrimary = 'P'");
        for (Object[] tuple : l) {
            InetAddress ip = (InetAddress)tuple[0];
            Integer nodeId = (Integer)tuple[1];
            map.put(ip, nodeId);
        }
        List s = this.getHibernateTemplate().find("select distinct ipInterface.ipAddress, ipInterface.node.id from OnmsIpInterface as ipInterface where ipInterface.isSnmpPrimary != 'P'");
        for (Object[] tuple : s) {
            InetAddress ip = (InetAddress)tuple[0];
            Integer nodeId = (Integer)tuple[1];
            if (map.containsKey(ip)) continue;
            map.put(ip, nodeId);
        }
        return map;
    }

    public boolean addressExistsWithForeignSource(String ipAddress, String foreignSource) {
        Assert.notNull((Object)ipAddress, (String)"ipAddress cannot be null");
        if (foreignSource == null) {
            return this.queryInt("select count(ipInterface.id) from OnmsIpInterface as ipInterface join ipInterface.node as node where node.foreignSource is NULL and ipInterface.ipAddress = ? ", ipAddress) > 0;
        }
        return this.queryInt("select count(ipInterface.id) from OnmsIpInterface as ipInterface join ipInterface.node as node where node.foreignSource = ? and ipInterface.ipAddress = ? ", foreignSource, ipAddress) > 0;
    }

    @Override
    public OnmsIpInterface findPrimaryInterfaceByNodeId(Integer nodeId) {
        Assert.notNull((Object)nodeId, (String)"nodeId cannot be null");
        List primaryInterfaces = this.find("from OnmsIpInterface as ipInterface where ipInterface.node.id = ? and ipInterface.isSnmpPrimary = 'P' order by ipLastCapsdPoll desc", nodeId);
        if (primaryInterfaces.size() < 1) {
            return null;
        }
        OnmsIpInterface retval = (OnmsIpInterface)primaryInterfaces.iterator().next();
        if (primaryInterfaces.size() > 1) {
            LOG.warn("Multiple primary SNMP interfaces for node {}, returning most recently scanned interface: {}", (Object)nodeId, (Object)retval.getInterfaceId());
        }
        return retval;
    }
}

