/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.distributed.datasource;

import java.lang.reflect.Constructor;
import java.util.Objects;
import javax.sql.DataSource;
import org.opennms.core.db.ClosableDataSource;
import org.opennms.netmgt.config.opennmsDataSources.ConnectionPool;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;

public class ConfigFactory {
    public DataSource createDataSource(ConnectionPool connectionPool, JdbcDataSource jdbcDataSource) throws Exception {
        Objects.requireNonNull(connectionPool);
        Objects.requireNonNull(jdbcDataSource);
        String connectionPoolFactoryClassName = connectionPool.getFactory();
        Class<?> clazz = Class.forName(connectionPoolFactoryClassName);
        Constructor<?> constructor = clazz.getConstructor(JdbcDataSource.class);
        ClosableDataSource dataSource = (ClosableDataSource)constructor.newInstance(jdbcDataSource);
        dataSource.setIdleTimeout(connectionPool.getIdleTimeout().intValue());
        dataSource.setLoginTimeout(connectionPool.getLoginTimeout().intValue());
        dataSource.setMinPool(connectionPool.getMinPool().intValue());
        dataSource.setMaxPool(connectionPool.getMaxPool().intValue());
        dataSource.setMaxSize(connectionPool.getMaxSize().intValue());
        return dataSource;
    }
}

