/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class VlanType
implements Comparable<VlanType>,
Serializable {
    private static final long serialVersionUID = -7012640218990540145L;
    public static final int VLAN_TYPE_UNKNOWN = 0;
    public static final int VLAN_TYPE_VTP_ETHERNET = 1;
    public static final int VLAN_TYPE_VTP_FDDI = 2;
    public static final int VLAN_TYPE_VTP_TOKENRING = 3;
    public static final int VLAN_TYPE_VTP_FDDINET = 4;
    public static final int VLAN_TYPE_VTP_TRNET = 5;
    public static final int VLAN_TYPE_VTP_DEPRECATED = 6;
    public static final int VLAN_TYPE_EXTREME_LAYERTWO = 7;
    public static final int THREECOM_STARTING_INDEX = 7;
    public static final int VLAN_TYPE_THREECOM_vlanLayer2 = 8;
    public static final int VLAN_TYPE_THREECOM_vlanUnspecifiedProtocols = 9;
    public static final int VLAN_TYPE_THREECOM_vlanIPProtocol = 10;
    public static final int VLAN_TYPE_THREECOM_vlanIPXProtocol = 11;
    public static final int VLAN_TYPE_THREECOM_vlanAppleTalkProtocol = 12;
    public static final int VLAN_TYPE_THREECOM_vlanXNSProtocol = 13;
    public static final int VLAN_TYPE_THREECOM_vlanISOProtocol = 14;
    public static final int VLAN_TYPE_THREECOM_vlanDECNetProtocol = 15;
    public static final int VLAN_TYPE_THREECOM_vlanNetBIOSProtocol = 16;
    public static final int VLAN_TYPE_THREECOM_vlanSNAProtocol = 17;
    public static final int VLAN_TYPE_THREECOM_vlanVINESProtocol = 18;
    public static final int VLAN_TYPE_THREECOM_vlanX25Protocol = 19;
    public static final int VLAN_TYPE_THREECOM_vlanIGMPProtocol = 20;
    public static final int VLAN_TYPE_THREECOM_vlanSessionLayer = 21;
    public static final int VLAN_TYPE_THREECOM_vlanNetBeui = 22;
    public static final int VLAN_TYPE_THREECOM_vlanLayeredProtocols = 23;
    public static final int VLAN_TYPE_THREECOM_vlanIPXIIProtocol = 24;
    public static final int VLAN_TYPE_THREECOM_vlanIPX8022Protocol = 25;
    public static final int VLAN_TYPE_THREECOM_vlanIPX8023Protocol = 26;
    public static final int VLAN_TYPE_THREECOM_vlanIPX8022SNAPProtocol = 27;
    private static final Integer[] s_order = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27};
    private Integer m_vlanType;
    private static final Map<Integer, String> vlanTypeMap = new HashMap<Integer, String>();
    public static final VlanType UNKNOWN;
    public static final VlanType CISCO_VTP_ETHERNET;
    public static final VlanType CISCO_VTP_FDDI;
    public static final VlanType CISCO_VTP_TOKENRING;
    public static final VlanType CISCO_VTP_FDDINET;
    public static final VlanType CISCO_VTP_TRNET;
    public static final VlanType CISCO_VTP_DEPRECATED;
    public static final VlanType EXTREME_LAYER2;
    public static final VlanType THREECOM_vlanLayer2;
    public static final VlanType THREECOM_vlanUnspecifiedProtocols;
    public static final VlanType THREECOM_vlanIPProtocol;
    public static final VlanType THREECOM_vlanIPXProtocol;
    public static final VlanType THREECOM_vlanAppleTalkProtocol;
    public static final VlanType THREECOM_vlanXNSProtocol;
    public static final VlanType THREECOM_vlanISOProtocol;
    public static final VlanType THREECOM_vlanDECNetProtocol;
    public static final VlanType THREECOM_vlanNetBIOSProtocol;
    public static final VlanType THREECOM_vlanSNAProtocol;
    public static final VlanType THREECOM_vlanVINESProtocol;
    public static final VlanType THREECOM_vlanX25Protocol;
    public static final VlanType THREECOM_vlanIGMPProtocol;
    public static final VlanType THREECOM_vlanSessionLayer;
    public static final VlanType THREECOM_vlanNetBeui;
    public static final VlanType THREECOM_vlanLayeredProtocols;
    public static final VlanType THREECOM_vlanIPXIIProtocol;
    public static final VlanType THREECOM_vlanIPX8022Protocol;
    public static final VlanType THREECOM_vlanIPX8023Protocol;
    public static final VlanType THREECOM_vlanIPX8022SNAPProtocol;

    private VlanType() {
    }

    public VlanType(Integer vlanType) {
        this.m_vlanType = vlanType;
    }

    public void setIntCode(Integer vlanType) {
        this.m_vlanType = vlanType;
    }

    @Override
    public int compareTo(VlanType o) {
        return VlanType.getIndex(this.m_vlanType) - VlanType.getIndex(o.m_vlanType);
    }

    private static int getIndex(Integer code) {
        for (int i = 0; i < s_order.length; ++i) {
            if (s_order[i] != code) continue;
            return i;
        }
        throw new IllegalArgumentException("illegal vlanType code '" + code + "'");
    }

    public boolean equals(Object o) {
        if (o instanceof VlanType) {
            return this.m_vlanType.intValue() == ((VlanType)o).m_vlanType.intValue();
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return String.valueOf(this.m_vlanType);
    }

    public static final VlanType get(Integer code) {
        if (code == null) {
            return UNKNOWN;
        }
        switch (code) {
            case 0: {
                return UNKNOWN;
            }
            case 1: {
                return CISCO_VTP_ETHERNET;
            }
            case 2: {
                return CISCO_VTP_FDDI;
            }
            case 3: {
                return CISCO_VTP_TOKENRING;
            }
            case 4: {
                return CISCO_VTP_FDDINET;
            }
            case 5: {
                return CISCO_VTP_TRNET;
            }
            case 6: {
                return CISCO_VTP_DEPRECATED;
            }
            case 7: {
                return EXTREME_LAYER2;
            }
            case 8: {
                return THREECOM_vlanLayer2;
            }
            case 9: {
                return THREECOM_vlanUnspecifiedProtocols;
            }
            case 10: {
                return THREECOM_vlanIPProtocol;
            }
            case 11: {
                return THREECOM_vlanIPXProtocol;
            }
            case 12: {
                return THREECOM_vlanAppleTalkProtocol;
            }
            case 13: {
                return THREECOM_vlanXNSProtocol;
            }
            case 14: {
                return THREECOM_vlanISOProtocol;
            }
            case 15: {
                return THREECOM_vlanDECNetProtocol;
            }
            case 16: {
                return THREECOM_vlanNetBIOSProtocol;
            }
            case 17: {
                return THREECOM_vlanSNAProtocol;
            }
            case 18: {
                return THREECOM_vlanVINESProtocol;
            }
            case 19: {
                return THREECOM_vlanX25Protocol;
            }
            case 20: {
                return THREECOM_vlanIGMPProtocol;
            }
            case 21: {
                return THREECOM_vlanSessionLayer;
            }
            case 22: {
                return THREECOM_vlanNetBeui;
            }
            case 23: {
                return THREECOM_vlanLayeredProtocols;
            }
            case 24: {
                return THREECOM_vlanIPXIIProtocol;
            }
            case 25: {
                return THREECOM_vlanIPX8022Protocol;
            }
            case 26: {
                return THREECOM_vlanIPX8023Protocol;
            }
            case 27: {
                return THREECOM_vlanIPX8022SNAPProtocol;
            }
        }
        throw new IllegalArgumentException("Cannot create vlanType from code " + code);
    }

    public static String getVlanTypeString(Integer code) {
        if (vlanTypeMap.containsKey(code)) {
            return vlanTypeMap.get(code);
        }
        return null;
    }

    static {
        vlanTypeMap.put(0, "Unknown");
        vlanTypeMap.put(1, "Ethernet");
        vlanTypeMap.put(2, "CiscoVtp/FDDI");
        vlanTypeMap.put(3, "CiscoVtp/TokenRing");
        vlanTypeMap.put(4, "CiscoVtp/FDDINet");
        vlanTypeMap.put(5, "CiscoVtp/TRNet");
        vlanTypeMap.put(6, "CiscoVtp/Deprecated");
        vlanTypeMap.put(7, "Extreme/LayerTwo");
        vlanTypeMap.put(8, "3com/vlanLayer2");
        vlanTypeMap.put(9, "3com/vlanUnspecifiedProtocols");
        vlanTypeMap.put(10, "3com/vlanIPProtocol");
        vlanTypeMap.put(11, "3com/vlanIPXProtocol");
        vlanTypeMap.put(12, "3com/vlanAppleTalkProtocol");
        vlanTypeMap.put(13, "3com/vlanXNSProtocol");
        vlanTypeMap.put(14, "3com/vlanISOProtocol");
        vlanTypeMap.put(15, "3com/vlanDECNetProtocol");
        vlanTypeMap.put(16, "3com/vlanNetBIOSProtocol");
        vlanTypeMap.put(17, "3com/vlanSNAProtocol");
        vlanTypeMap.put(18, "3com/vlanVINESProtocol");
        vlanTypeMap.put(19, "3com/vlanX25Protocol");
        vlanTypeMap.put(20, "3com/vlanIGMPProtocol");
        vlanTypeMap.put(21, "3com/vlanSessionLayer");
        vlanTypeMap.put(22, "3com/vlanNetBeui");
        vlanTypeMap.put(23, "3com/vlanLayeredProtocols");
        vlanTypeMap.put(24, "3com/vlanIPXIIProtocol");
        vlanTypeMap.put(25, "3com/vlanIPX8022Protocol");
        vlanTypeMap.put(26, "3com/vlanIPX8023Protocol");
        vlanTypeMap.put(27, "3com/vlanIPX8022SNAPProtocol");
        UNKNOWN = new VlanType(0);
        CISCO_VTP_ETHERNET = new VlanType(1);
        CISCO_VTP_FDDI = new VlanType(2);
        CISCO_VTP_TOKENRING = new VlanType(3);
        CISCO_VTP_FDDINET = new VlanType(4);
        CISCO_VTP_TRNET = new VlanType(5);
        CISCO_VTP_DEPRECATED = new VlanType(6);
        EXTREME_LAYER2 = new VlanType(7);
        THREECOM_vlanLayer2 = new VlanType(8);
        THREECOM_vlanUnspecifiedProtocols = new VlanType(9);
        THREECOM_vlanIPProtocol = new VlanType(10);
        THREECOM_vlanIPXProtocol = new VlanType(11);
        THREECOM_vlanAppleTalkProtocol = new VlanType(12);
        THREECOM_vlanXNSProtocol = new VlanType(13);
        THREECOM_vlanISOProtocol = new VlanType(14);
        THREECOM_vlanDECNetProtocol = new VlanType(15);
        THREECOM_vlanNetBIOSProtocol = new VlanType(16);
        THREECOM_vlanSNAProtocol = new VlanType(17);
        THREECOM_vlanVINESProtocol = new VlanType(18);
        THREECOM_vlanX25Protocol = new VlanType(19);
        THREECOM_vlanIGMPProtocol = new VlanType(20);
        THREECOM_vlanSessionLayer = new VlanType(21);
        THREECOM_vlanNetBeui = new VlanType(22);
        THREECOM_vlanLayeredProtocols = new VlanType(23);
        THREECOM_vlanIPXIIProtocol = new VlanType(24);
        THREECOM_vlanIPX8022Protocol = new VlanType(25);
        THREECOM_vlanIPX8023Protocol = new VlanType(26);
        THREECOM_vlanIPX8022SNAPProtocol = new VlanType(27);
    }
}

