/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.opennms.netmgt.config.GroupManager;
import org.opennms.netmgt.config.WebCalendar;
import org.opennms.netmgt.config.Week;
import org.opennms.netmgt.config.groups.Role;

public class MonthlyCalendar
implements WebCalendar {
    private GregorianCalendar m_calendar;
    private Role m_role;
    private GroupManager m_groupManager;

    public MonthlyCalendar(Date date, Role role, GroupManager groupManager) {
        this.m_role = role;
        this.m_groupManager = groupManager;
        this.m_calendar = new GregorianCalendar();
        this.m_calendar.setTime(date);
    }

    public int getMonth() {
        return this.m_calendar.get(2);
    }

    private int getYear() {
        return this.m_calendar.get(1);
    }

    @Override
    public String getMonthAndYear() {
        return new SimpleDateFormat("MMMM yyyy").format(this.m_calendar.getTime());
    }

    private boolean isFirstOfWeek(Calendar cal) {
        return cal.get(7) == cal.getFirstDayOfWeek();
    }

    private Calendar getDateOfFirstWeek() {
        Calendar first = this.getFirstOfMonth();
        if (!this.isFirstOfWeek(first)) {
            first.set(7, first.getFirstDayOfWeek());
            first.set(8, 0);
        }
        return first;
    }

    private Calendar getFirstOfMonth() {
        return new GregorianCalendar(this.getYear(), this.getMonth(), 1);
    }

    @Override
    public Week[] getWeeks() {
        Calendar weekBegin = this.getDateOfFirstWeek();
        ArrayList<Week> weeks = new ArrayList<Week>(6);
        do {
            weeks.add(new Week(weekBegin.getTime(), this.m_role, this.m_groupManager));
            weekBegin.add(6, 7);
        } while (this.isThisMonth(weekBegin));
        return weeks.toArray(new Week[weeks.size()]);
    }

    private boolean isThisMonth(Calendar weekBegin) {
        return weekBegin.get(2) == this.getMonth();
    }

    @Override
    public Date getNextMonth() {
        return new GregorianCalendar(this.getYear(), this.getMonth() + 1, 1).getTime();
    }

    @Override
    public Date getPreviousMonth() {
        return new GregorianCalendar(this.getYear(), this.getMonth() - 1, 1).getTime();
    }
}

