/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.RouteContext;

public class TypedProcessorFactory<T extends ProcessorDefinition<T>>
implements ProcessorFactory {
    private final Class<T> type;

    protected TypedProcessorFactory(Class<T> type) {
        this.type = type;
    }

    @Override
    public Processor createChildProcessor(RouteContext routeContext, ProcessorDefinition<?> definition, boolean mandatory) throws Exception {
        if (definition != null && this.type.isInstance(definition)) {
            return this.doCreateChildProcessor(routeContext, (ProcessorDefinition)this.type.cast(definition), mandatory);
        }
        return null;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext, ProcessorDefinition<?> definition) throws Exception {
        if (definition != null && this.type.isInstance(definition)) {
            return this.doCreateProcessor(routeContext, (ProcessorDefinition)this.type.cast(definition));
        }
        return null;
    }

    protected Processor doCreateChildProcessor(RouteContext routeContext, T definition, boolean mandatory) throws Exception {
        return null;
    }

    public Processor doCreateProcessor(RouteContext routeContext, T definition) throws Exception {
        return null;
    }
}

