/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.commands.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.Parsing;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Parser;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.support.ShellUtil;
import org.apache.karaf.shell.support.completers.CommandsCompleter;
import org.apache.karaf.shell.support.parsing.CommandLineImpl;
import org.apache.karaf.shell.support.parsing.DefaultParser;
import org.apache.karaf.util.ThreadUtils;
import org.jline.terminal.Attributes;
import org.jline.terminal.Terminal;

@Command(scope="shell", name="watch", description="Watches & refreshes the output of a command")
@Parsing(value=WatchParser.class)
@Service
public class WatchAction
implements Action {
    @Option(name="-n", aliases={"--interval"}, description="The interval between executions of the command in seconds", required=false, multiValued=false)
    private long interval = 1L;
    @Option(name="-a", aliases={"--append"}, description="The output should be appended but not clear the console", required=false, multiValued=false)
    private boolean append = false;
    @Argument(index=0, name="command", description="The command to watch / refresh", required=true, multiValued=false)
    @Completion(value=SubCommandCompleter.class)
    private String arguments;
    @Reference
    Session session;
    @Reference
    SessionFactory sessionFactory;
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(ThreadUtils.namedThreadFactory("shell:watch"));
    private boolean abort;
    private Thread reading;
    private Thread executing;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() throws Exception {
        if (this.arguments == null || this.arguments.length() == 0) {
            System.err.println("Argument expected");
        } else {
            WatchTask watchTask = new WatchTask();
            this.executorService.scheduleAtFixedRate(watchTask, 0L, this.interval, TimeUnit.SECONDS);
            try {
                Terminal terminal = (Terminal)this.session.get(".jline.terminal");
                Terminal.SignalHandler prev = terminal.handle(Terminal.Signal.INT, this::abort);
                Attributes attr = terminal.enterRawMode();
                try {
                    this.reading = Thread.currentThread();
                    while (terminal.reader().read(1L) == -2) {
                    }
                }
                finally {
                    this.reading = null;
                    terminal.setAttributes(attr);
                    terminal.handle(Terminal.Signal.INT, prev);
                }
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            finally {
                this.abort = true;
                this.executorService.shutdownNow();
            }
        }
        return null;
    }

    private void abort(Terminal.Signal signal) {
        this.abort = true;
        if (this.reading != null) {
            this.reading.interrupt();
        }
        if (this.executing != null) {
            this.executing.interrupt();
        }
    }

    @Service
    public static class SubCommandCompleter
    implements Completer {
        public int complete(Session session, CommandLine commandLine, List<String> candidates) {
            String arg = commandLine.getCursorArgument();
            int pos = commandLine.getArgumentPosition();
            CommandLine cmdLine = new DefaultParser().parse(session, arg, pos);
            Completer completer = (Completer)session.getRegistry().getService(CommandsCompleter.class);
            ArrayList cands = new ArrayList();
            int res = completer.complete(session, cmdLine, cands);
            for (String cand : cands) {
                candidates.add(arg.substring(0, cmdLine.getBufferPosition() - cmdLine.getArgumentPosition()) + cand);
            }
            if (res >= 0) {
                res += commandLine.getBufferPosition() - commandLine.getArgumentPosition();
            }
            return res;
        }
    }

    @Service
    public static class WatchParser
    implements Parser {
        public CommandLine parse(Session session, String command, int cursor) {
            int n1 = 0;
            while (n1 < command.length() && Character.isWhitespace(command.charAt(n1))) {
                if (++n1 != command.length()) continue;
                throw new IllegalArgumentException();
            }
            int n2 = n1 + 1;
            while (!Character.isWhitespace(command.charAt(n2))) {
                if (++n2 != command.length()) continue;
                return new CommandLineImpl(new String[]{command.substring(n1)}, 0, cursor - n1, cursor, command);
            }
            int n3 = n2 + 1;
            while (n3 < command.length() && Character.isWhitespace(command.charAt(n3))) {
                if (++n3 != command.length()) continue;
                return new CommandLineImpl(new String[]{command.substring(n1, n2), ""}, cursor >= n2 ? 1 : 0, cursor >= n2 ? 0 : cursor - n1, cursor, command);
            }
            return new CommandLineImpl(new String[]{command.substring(n1, n2), command.substring(n3)}, cursor >= n3 ? 1 : 0, cursor >= n3 ? cursor - n3 : cursor - n1, cursor, command);
        }

        public String preprocess(Session session, CommandLine cmdLine) {
            StringBuilder parsed = new StringBuilder();
            for (int i = 0; i < cmdLine.getArguments().length; ++i) {
                String arg = cmdLine.getArguments()[i];
                if (i > 0) {
                    parsed.append(" \"");
                }
                parsed.append(arg);
                if (i <= 0) continue;
                parsed.append("\"");
            }
            return parsed.toString();
        }
    }

    public class WatchTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                try (Session session = WatchAction.this.sessionFactory.create((InputStream)new ByteArrayInputStream(new byte[0]), printStream, printStream, WatchAction.this.session);){
                    WatchAction.this.executing = Thread.currentThread();
                    session.execute((CharSequence)WatchAction.this.arguments.trim());
                }
                catch (InterruptedException e) {
                    WatchAction.this.abort(null);
                }
                catch (Exception e) {
                    ShellUtil.logException((Session)WatchAction.this.session, (Throwable)e);
                }
                finally {
                    WatchAction.this.executing = null;
                }
                printStream.flush();
                if (!WatchAction.this.abort) {
                    if (!WatchAction.this.append) {
                        System.out.print("\u001b[2J");
                        System.out.print("\u001b[1;1H");
                    }
                    System.out.print(byteArrayOutputStream.toString());
                    System.out.flush();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

