/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.dhcpd.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import java.net.InetAddress;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.dhcpd.Transaction;
import org.opennms.features.dhcpd.impl.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionImpl
implements Transaction {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionImpl.class);
    private static final Set<Byte> EXTENDED_MODE_ACCEPTED_RESPONSES = Sets.newHashSet((Object[])new Byte[]{(byte)2, (byte)5, (byte)6});
    private static final int MAC_ADDRESS_LENGTH = 6;
    private static final byte[] DEFAULT_MAC_ADDRESS = new byte[]{0, 6, 13, -66, -100, -78, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final InetAddress hostAddress;
    private final byte[] macAddress;
    private final InetAddress requestIpAddress;
    private final boolean extendedMode;
    private final boolean relayMode;
    private final InetAddress myIpAddress;
    private final int timeout;
    private int xid;
    private boolean success = false;
    private Response response;
    private long startTime = -1L;
    private long endTime = -1L;

    public TransactionImpl(String hostAddress, String macAddress, boolean relayMode, String myIpAddress, boolean extendedMode, String requestIpAddress, int timeout) {
        this.hostAddress = InetAddressUtils.addr((String)hostAddress);
        this.macAddress = this.parseMacAddress(macAddress);
        this.requestIpAddress = InetAddressUtils.addr((String)requestIpAddress);
        this.relayMode = relayMode;
        this.myIpAddress = InetAddressUtils.addr((String)(myIpAddress != null ? myIpAddress : "0.0.0.0"));
        this.extendedMode = extendedMode;
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean check(Response response) {
        if (this.isExtendedMode()) {
            this.success = response.getDhcpPacket().getXid() == this.xid && EXTENDED_MODE_ACCEPTED_RESPONSES.contains(response.getDhcpPacket().getDHCPMessageType());
        } else {
            boolean bl = this.success = response.getDhcpPacket().getXid() == this.xid && response.getDhcpPacket().getDHCPMessageType() == 2;
        }
        if (this.success) {
            this.response = response;
            this.endTime = System.currentTimeMillis();
        }
        return this.success;
    }

    public void updateStartTime() {
        if (!this.isSuccess()) {
            this.startTime = System.currentTimeMillis();
        }
    }

    @Override
    public long getResponseTime() {
        if (this.isSuccess()) {
            return this.endTime - this.startTime;
        }
        return -1L;
    }

    public Response getResponse() {
        return this.response;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    public InetAddress getHostAddress() {
        return this.hostAddress;
    }

    public byte[] getMacAddress() {
        return this.macAddress;
    }

    public InetAddress getRequestIpAddress() {
        return this.requestIpAddress;
    }

    public boolean isExtendedMode() {
        return this.extendedMode;
    }

    public boolean isRelayMode() {
        return this.relayMode;
    }

    private byte[] parseMacAddress(String macAddressString) {
        byte[] macAddressBytes = DEFAULT_MAC_ADDRESS;
        String[] elements = macAddressString.split(":");
        if (elements.length != 6) {
            LOG.debug("Invalid format for MAC address {}", (Object)macAddressString);
        } else {
            for (int i = 0; i < 6; ++i) {
                try {
                    macAddressBytes[i] = (byte)Integer.parseInt(elements[i], 16);
                    continue;
                }
                catch (NumberFormatException e) {
                    LOG.debug("Error parsing octet {} MAC address {}", (Object)i, (Object)e);
                }
            }
        }
        return macAddressBytes;
    }

    public int getXid() {
        return this.xid;
    }

    public void setXid(int xid) {
        this.xid = xid;
    }

    public InetAddress getMyIpAddress() {
        return this.myIpAddress;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hostAddress", (Object)this.hostAddress).add("macAddress", (Object)this.macAddress).add("requestIpAddress", (Object)this.requestIpAddress).add("extendedMode", this.extendedMode).add("relayMode", this.relayMode).add("myIpAddress", (Object)this.myIpAddress).add("timeout", this.timeout).add("xid", this.xid).add("success", this.success).add("response", (Object)this.response).toString();
    }
}

