/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.camel;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.opennms.core.xml.JaxbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxbUtilsUnmarshalProcessor
implements Processor {
    public static final Logger LOG = LoggerFactory.getLogger(JaxbUtilsUnmarshalProcessor.class);
    private final Class<?> m_class;
    private final ThreadLocal<Unmarshaller> m_unmarshaller = new ThreadLocal();

    public JaxbUtilsUnmarshalProcessor(Class clazz) {
        this.m_class = clazz;
    }

    public JaxbUtilsUnmarshalProcessor(String className) throws ClassNotFoundException {
        this(Class.forName(className));
    }

    public void process(Exchange exchange) throws Exception {
        Unmarshaller unmarshaller = this.m_unmarshaller.get();
        if (unmarshaller == null) {
            unmarshaller = JaxbUtils.getUnmarshallerFor(this.m_class, null, (boolean)false);
            this.m_unmarshaller.set(unmarshaller);
        }
        String object = (String)exchange.getIn().getBody(String.class);
        exchange.getIn().setBody(this.m_class.cast(unmarshaller.unmarshal((Reader)new StringReader(object))));
    }
}

