/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jmx.impl.connection.connectors;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.opennms.netmgt.jmx.connection.JmxConnectionConfig;
import org.opennms.netmgt.jmx.connection.JmxConnectionConfigBuilder;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionException;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionWrapper;
import org.opennms.netmgt.jmx.connection.JmxServerConnector;
import org.opennms.netmgt.jmx.impl.connection.connectors.DefaultConnectionWrapper;
import org.opennms.netmgt.jmx.impl.connection.connectors.PlatformMBeanServerConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJmxConnector
implements JmxServerConnector {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJmxConnector.class);

    public JmxServerConnectionWrapper createConnection(InetAddress ipAddress, Map<String, String> propertiesMap) throws JmxServerConnectionException {
        JmxConnectionConfig config = JmxConnectionConfigBuilder.buildFrom((InetAddress)ipAddress, propertiesMap).build();
        return this.createConnection(config);
    }

    public JmxServerConnectionWrapper createConnection(JmxConnectionConfig config) throws JmxServerConnectionException {
        try {
            if (config.isLocalConnection()) {
                return new PlatformMBeanServerConnector().createConnection();
            }
            String urlString = config.getUrl();
            JMXServiceURL url = new JMXServiceURL(urlString);
            LOG.debug("JMX: {} - {}", (Object)config.getFactory(), (Object)url);
            HashMap env = new HashMap();
            config.getPasswordStategy().apply(env, config);
            JMXConnector connector = JMXConnectorFactory.newJMXConnector(url, env);
            try {
                connector.connect(env);
            }
            catch (SecurityException x) {
                throw new JmxServerConnectionException("Security exception: bad credentials", (Exception)x);
            }
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            DefaultConnectionWrapper connectionWrapper = new DefaultConnectionWrapper(connector, connection);
            return connectionWrapper;
        }
        catch (MalformedURLException e) {
            throw new JmxServerConnectionException((IOException)e);
        }
        catch (IOException e) {
            throw new JmxServerConnectionException(e);
        }
    }
}

