/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.util.Optional;
import org.opennms.netmgt.model.LldpElement;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.ReadOnlyEntity;

@ReadOnlyEntity
public class LldpElementTopologyEntity {
    private final Integer id;
    private final String lldpChassisId;
    private final Integer nodeId;

    public LldpElementTopologyEntity(Integer id, String lldpChassisId, Integer nodeId) {
        this.id = id;
        this.lldpChassisId = lldpChassisId;
        this.nodeId = nodeId;
    }

    public static LldpElementTopologyEntity create(LldpElement element) {
        return new LldpElementTopologyEntity(element.getId(), element.getLldpChassisId(), Optional.ofNullable(element.getNode()).map(OnmsNode::getId).orElse(null));
    }

    public Integer getId() {
        return this.id;
    }

    public String getLldpChassisId() {
        return this.lldpChassisId;
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    public String getNodeIdAsString() {
        if (this.getNodeId() != null) {
            return this.getNodeId().toString();
        }
        return null;
    }
}

