/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.snmp4j;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.CommunityTarget;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.TransportStateReference;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.AbstractTransportMapping;
import org.snmp4j.transport.DummyTransport;
import org.snmp4j.transport.TransportListener;

public class Snmp4JUtils {
    private static final transient Logger LOG = LoggerFactory.getLogger(Snmp4JUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convertPduToBytes(InetAddress address, int port, String community, PDU pdu) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference bytes = new AtomicReference();
        DummyTransport<Object> transport = new DummyTransport<Object>(null);
        AbstractTransportMapping<Object> responder = transport.getResponder(null);
        responder.addTransportListener(new TransportListener(){

            @Override
            public void processMessage(TransportMapping transport, Address address, ByteBuffer byteBuffer, TransportStateReference state) {
                byteBuffer.rewind();
                byte[] byteArray = new byte[byteBuffer.remaining()];
                byteBuffer.get(byteArray);
                bytes.set(byteArray);
                byteBuffer.rewind();
                latch.countDown();
            }
        });
        MessageDispatcherImpl dispatcher = new MessageDispatcherImpl();
        dispatcher.addMessageProcessingModel(new MPv1());
        dispatcher.addMessageProcessingModel(new MPv2c());
        try (Snmp snmp = new Snmp(dispatcher, responder);){
            snmp.listen();
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(new OctetString(community));
            if (pdu instanceof PDUv1) {
                target.setVersion(0);
            } else {
                target.setVersion(1);
            }
            target.setAddress(Snmp4JAgentConfig.convertAddress(address, port));
            snmp.send(pdu, target, transport);
            latch.await();
            byte[] byArray = (byte[])bytes.get();
            return byArray;
        }
    }
}

