/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.viewsdisplay;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.viewsdisplay.View;

@XmlRootElement(name="viewinfo")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Viewinfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_DEFAULT_VIEW = "WebConsoleView";
    @XmlAttribute(name="disconnect-timeout")
    private Integer disconnectTimeout;
    @XmlAttribute(name="default-view")
    private String defaultView;
    @XmlElement(name="view")
    private List<View> viewList = new ArrayList<View>();

    public void addView(View vView) throws IndexOutOfBoundsException {
        this.viewList.add(vView);
    }

    public void addView(int index, View vView) throws IndexOutOfBoundsException {
        this.viewList.add(index, vView);
    }

    public void deleteDisconnectTimeout() {
        this.disconnectTimeout = null;
    }

    public Enumeration<View> enumerateView() {
        return Collections.enumeration(this.viewList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Viewinfo) {
            Viewinfo temp = (Viewinfo)obj;
            boolean equals = Objects.equals(temp.disconnectTimeout, this.disconnectTimeout) && Objects.equals(temp.defaultView, this.defaultView) && Objects.equals(temp.viewList, this.viewList);
            return equals;
        }
        return false;
    }

    public String getDefaultView() {
        return this.defaultView != null ? this.defaultView : DEFAULT_DEFAULT_VIEW;
    }

    public Integer getDisconnectTimeout() {
        return this.disconnectTimeout != null ? this.disconnectTimeout : Integer.valueOf("130000");
    }

    public View getView(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.viewList.size()) {
            throw new IndexOutOfBoundsException("getView: Index value '" + index + "' not in range [0.." + (this.viewList.size() - 1) + "]");
        }
        return this.viewList.get(index);
    }

    public View[] getView() {
        View[] array = new View[]{};
        return this.viewList.toArray(array);
    }

    public List<View> getViewCollection() {
        return this.viewList;
    }

    public int getViewCount() {
        return this.viewList.size();
    }

    public boolean hasDisconnectTimeout() {
        return this.disconnectTimeout != null;
    }

    public int hashCode() {
        int hash = Objects.hash(this.disconnectTimeout, this.defaultView, this.viewList);
        return hash;
    }

    public Iterator<View> iterateView() {
        return this.viewList.iterator();
    }

    public void removeAllView() {
        this.viewList.clear();
    }

    public boolean removeView(View vView) {
        boolean removed = this.viewList.remove(vView);
        return removed;
    }

    public View removeViewAt(int index) {
        View obj = this.viewList.remove(index);
        return obj;
    }

    public void setDefaultView(String defaultView) {
        this.defaultView = defaultView;
    }

    public void setDisconnectTimeout(Integer disconnectTimeout) {
        this.disconnectTimeout = disconnectTimeout;
    }

    public void setView(int index, View vView) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.viewList.size()) {
            throw new IndexOutOfBoundsException("setView: Index value '" + index + "' not in range [0.." + (this.viewList.size() - 1) + "]");
        }
        this.viewList.set(index, vView);
    }

    public void setView(View[] vViewArray) {
        this.viewList.clear();
        for (int i = 0; i < vViewArray.length; ++i) {
            this.viewList.add(vViewArray[i]);
        }
    }

    public void setView(List<View> vViewList) {
        this.viewList.clear();
        this.viewList.addAll(vViewList);
    }

    public void setViewCollection(List<View> viewList) {
        this.viewList = viewList;
    }
}

