/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.threshd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.threshd.Parameter;

@XmlRootElement(name="thresholder")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Thresholder
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="service", required=true)
    private String service;
    @XmlAttribute(name="class-name", required=true)
    private String className;
    @XmlElement(name="parameter")
    private List<Parameter> parameterList = new ArrayList<Parameter>();

    public void addParameter(Parameter vParameter) throws IndexOutOfBoundsException {
        this.parameterList.add(vParameter);
    }

    public void addParameter(int index, Parameter vParameter) throws IndexOutOfBoundsException {
        this.parameterList.add(index, vParameter);
    }

    public Enumeration<Parameter> enumerateParameter() {
        return Collections.enumeration(this.parameterList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Thresholder) {
            Thresholder temp = (Thresholder)obj;
            boolean equals = Objects.equals(temp.service, this.service) && Objects.equals(temp.className, this.className) && Objects.equals(temp.parameterList, this.parameterList);
            return equals;
        }
        return false;
    }

    public String getClassName() {
        return this.className;
    }

    public Parameter getParameter(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.parameterList.size()) {
            throw new IndexOutOfBoundsException("getParameter: Index value '" + index + "' not in range [0.." + (this.parameterList.size() - 1) + "]");
        }
        return this.parameterList.get(index);
    }

    public Parameter[] getParameter() {
        Parameter[] array = new Parameter[]{};
        return this.parameterList.toArray(array);
    }

    public List<Parameter> getParameterCollection() {
        return this.parameterList;
    }

    public int getParameterCount() {
        return this.parameterList.size();
    }

    public String getService() {
        return this.service;
    }

    public int hashCode() {
        int hash = Objects.hash(this.service, this.className, this.parameterList);
        return hash;
    }

    public Iterator<Parameter> iterateParameter() {
        return this.parameterList.iterator();
    }

    public void removeAllParameter() {
        this.parameterList.clear();
    }

    public boolean removeParameter(Parameter vParameter) {
        boolean removed = this.parameterList.remove(vParameter);
        return removed;
    }

    public Parameter removeParameterAt(int index) {
        Parameter obj = this.parameterList.remove(index);
        return obj;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setParameter(int index, Parameter vParameter) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.parameterList.size()) {
            throw new IndexOutOfBoundsException("setParameter: Index value '" + index + "' not in range [0.." + (this.parameterList.size() - 1) + "]");
        }
        this.parameterList.set(index, vParameter);
    }

    public void setParameter(Parameter[] vParameterArray) {
        this.parameterList.clear();
        for (int i = 0; i < vParameterArray.length; ++i) {
            this.parameterList.add(vParameterArray[i]);
        }
    }

    public void setParameter(List<Parameter> vParameterList) {
        this.parameterList.clear();
        this.parameterList.addAll(vParameterList);
    }

    public void setParameterCollection(List<Parameter> parameterList) {
        this.parameterList = parameterList;
    }

    public void setService(String service) {
        this.service = service;
    }
}

