/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.statsd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.config.statsd.Filter;
import org.opennms.netmgt.config.statsd.PackageReport;

@XmlRootElement(name="package")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Package
implements Serializable {
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlElement(name="filter")
    private Filter filter;
    @XmlElement(name="packageReport")
    private List<PackageReport> packageReportList = new ArrayList<PackageReport>();

    public void addPackageReport(PackageReport vPackageReport) throws IndexOutOfBoundsException {
        this.packageReportList.add(vPackageReport);
    }

    public void addPackageReport(int index, PackageReport vPackageReport) throws IndexOutOfBoundsException {
        this.packageReportList.add(index, vPackageReport);
    }

    public Enumeration<PackageReport> enumeratePackageReport() {
        return Collections.enumeration(this.packageReportList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Package) {
            Package temp = (Package)obj;
            boolean equals = Objects.equals(temp.name, this.name) && Objects.equals(temp.filter, this.filter) && Objects.equals(temp.packageReportList, this.packageReportList);
            return equals;
        }
        return false;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public String getName() {
        return this.name;
    }

    public PackageReport getPackageReport(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.packageReportList.size()) {
            throw new IndexOutOfBoundsException("getPackageReport: Index value '" + index + "' not in range [0.." + (this.packageReportList.size() - 1) + "]");
        }
        return this.packageReportList.get(index);
    }

    public PackageReport[] getPackageReport() {
        PackageReport[] array = new PackageReport[]{};
        return this.packageReportList.toArray(array);
    }

    public List<PackageReport> getPackageReportCollection() {
        return this.packageReportList;
    }

    public int getPackageReportCount() {
        return this.packageReportList.size();
    }

    public int hashCode() {
        int hash = Objects.hash(this.name, this.filter, this.packageReportList);
        return hash;
    }

    public Iterator<PackageReport> iteratePackageReport() {
        return this.packageReportList.iterator();
    }

    public void removeAllPackageReport() {
        this.packageReportList.clear();
    }

    public boolean removePackageReport(PackageReport vPackageReport) {
        boolean removed = this.packageReportList.remove(vPackageReport);
        return removed;
    }

    public PackageReport removePackageReportAt(int index) {
        PackageReport obj = this.packageReportList.remove(index);
        return obj;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPackageReport(int index, PackageReport vPackageReport) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.packageReportList.size()) {
            throw new IndexOutOfBoundsException("setPackageReport: Index value '" + index + "' not in range [0.." + (this.packageReportList.size() - 1) + "]");
        }
        this.packageReportList.set(index, vPackageReport);
    }

    public void setPackageReport(PackageReport[] vPackageReportArray) {
        this.packageReportList.clear();
        for (int i = 0; i < vPackageReportArray.length; ++i) {
            this.packageReportList.add(vPackageReportArray[i]);
        }
    }

    public void setPackageReport(List<PackageReport> vPackageReportList) {
        this.packageReportList.clear();
        this.packageReportList.addAll(vPackageReportList);
    }

    public void setPackageReportCollection(List<PackageReport> packageReportList) {
        this.packageReportList = packageReportList;
    }
}

