/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.syslogd.GrokParserStageSequenceBuilder;
import org.opennms.netmgt.syslogd.ParserStage;
import org.opennms.netmgt.syslogd.RadixTreeParser;
import org.opennms.netmgt.syslogd.SyslogMessage;
import org.opennms.netmgt.syslogd.SyslogParser;

public class RadixTreeSyslogParser
extends SyslogParser {
    private static final Pattern STRUCTURED_DATA = Pattern.compile("^(?:\\[.*?\\])*(?: \ufeff?(.*?))?$");
    private static RadixTreeParser radixParser = new RadixTreeParser();

    public RadixTreeSyslogParser(SyslogdConfig config, ByteBuffer syslogString) {
        super(config, syslogString);
    }

    @Override
    public boolean find() {
        return true;
    }

    @Override
    public SyslogMessage parse() {
        Matcher matcher;
        String message;
        SyslogMessage retval = radixParser.parse(this.getText()).join();
        if (retval != null && (message = retval.getMessage()) != null && message.startsWith("[") && (matcher = STRUCTURED_DATA.matcher(message)).find()) {
            String newMessage = matcher.group(1);
            retval.setMessage(newMessage == null ? null : newMessage);
        }
        return retval;
    }

    static {
        new BufferedReader(new InputStreamReader(RadixTreeSyslogParser.class.getClassLoader().getResourceAsStream("org/opennms/netmgt/syslogd/grok-patterns.txt"))).lines().forEach(pattern -> {
            if (pattern == null || pattern.trim().length() == 0 || pattern.trim().startsWith("#")) {
                return;
            }
            radixParser.teach(GrokParserStageSequenceBuilder.parseGrok(pattern).toArray(new ParserStage[0]));
        });
        radixParser.performEdgeCompression();
    }
}

