/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.opennms.netmgt.config.GroupManager;
import org.opennms.netmgt.config.MonthlyCalendar;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.config.WebCalendar;
import org.opennms.netmgt.config.WebGroup;
import org.opennms.netmgt.config.WebGroupManager;
import org.opennms.netmgt.config.WebRole;
import org.opennms.netmgt.config.WebRoleManager;
import org.opennms.netmgt.config.WebRolesException;
import org.opennms.netmgt.config.WebSchedEntry;
import org.opennms.netmgt.config.WebUser;
import org.opennms.netmgt.config.WebUserManager;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.config.groups.Role;
import org.opennms.netmgt.config.groups.Schedule;
import org.opennms.netmgt.config.groups.Time;
import org.opennms.netmgt.config.users.User;

public class WebRoleManagerImpl
implements WebRoleManager,
WebUserManager,
WebGroupManager {
    private GroupManager m_groupManager;
    private UserManager m_userManager;

    private User getBackingUser(String name) {
        try {
            return this.m_userManager.getUser(name);
        }
        catch (IOException e) {
            throw new WebRolesException("Error reading users.xml config file", e);
        }
    }

    private Collection<User> getBackingUsers() {
        try {
            return this.m_userManager.getUsers().values();
        }
        catch (IOException e) {
            throw new WebRolesException("Error reading users.xml config file", e);
        }
    }

    private Role getBackingRole(String roleName) {
        return this.m_groupManager.getRole(roleName);
    }

    private Group getBackingGroup(String groupName) {
        try {
            return this.m_groupManager.getGroup(groupName);
        }
        catch (IOException e) {
            throw new WebRolesException("Error reading groups.xml config file", e);
        }
    }

    private Collection<Group> getBackingGroups() {
        try {
            return this.m_groupManager.getGroups().values();
        }
        catch (IOException e) {
            throw new WebRolesException("Error reading groups.xml config file", e);
        }
    }

    private Collection<WebUser> getUsersScheduleForRole(WebRole role, Date time) {
        try {
            String[] users = this.m_userManager.getUsersScheduledForRole(role.getName(), new Date());
            ArrayList<WebUser> webUsers = new ArrayList<WebUser>(users.length);
            for (String user : users) {
                webUsers.add(this.getWebUser(user));
            }
            return webUsers;
        }
        catch (IOException e) {
            throw new WebRolesException("Error reading users.xml config file", e);
        }
    }

    private WebRole getWebRole(Role role) {
        return new ManagedRole(role);
    }

    private WebUser getWebUser(String userName) {
        User u = this.getBackingUser(userName);
        if (u == null) {
            return new InvalidUser(userName);
        }
        return new ManagedUser(u);
    }

    private WebUser getWebUser(User user) {
        if (user == null) {
            return new InvalidUser("Select A Valid User...");
        }
        return new ManagedUser(user);
    }

    private WebGroup getWebGroup(String groupName) {
        Group g = this.getBackingGroup(groupName);
        if (g == null) {
            return new InvalidGroup(groupName);
        }
        return new ManagedGroup(g);
    }

    private WebGroup getWebGroup(Group group) {
        if (group == null) {
            return new InvalidGroup("Select a valid group...");
        }
        return new ManagedGroup(group);
    }

    private ManagedRole getManagedRole(WebRole webRole) {
        if (webRole instanceof ManagedRole) {
            return (ManagedRole)webRole;
        }
        ManagedRole mgdRole = new ManagedRole(webRole);
        return mgdRole;
    }

    @Override
    public WebRole createRole() {
        return new ManagedRole();
    }

    public WebRoleManagerImpl(GroupManager groupManager, UserManager userManager) {
        this.m_groupManager = groupManager;
        this.m_userManager = userManager;
    }

    @Override
    public Collection<WebRole> getRoles() {
        Collection<Role> roles = this.m_groupManager.getRoles();
        ArrayList<WebRole> webRoles = new ArrayList<WebRole>(roles.size());
        for (Role role : roles) {
            webRoles.add(this.getWebRole(role));
        }
        return webRoles;
    }

    @Override
    public void deleteRole(String roleName) {
        try {
            this.m_groupManager.deleteRole(roleName);
        }
        catch (Throwable e) {
            throw new WebRolesException("Error deleting role " + roleName + ". " + e.getMessage(), e);
        }
    }

    @Override
    public WebRole getRole(String roleName) {
        Role role = this.getBackingRole(roleName);
        return role == null ? null : this.getWebRole(role);
    }

    @Override
    public void saveRole(WebRole webRole) {
        try {
            ManagedRole mgdRole = this.getManagedRole(webRole);
            mgdRole.save();
        }
        catch (Throwable e) {
            throw new WebRolesException("Error saving roles. " + e.getMessage(), e);
        }
    }

    @Override
    public Collection<WebUser> getUsers() {
        ArrayList<WebUser> users = new ArrayList<WebUser>();
        for (User u : this.getBackingUsers()) {
            users.add(this.getWebUser(u));
        }
        return users;
    }

    @Override
    public WebUser getUser(String name) {
        return this.getWebUser(name);
    }

    @Override
    public Collection<WebGroup> getGroups() {
        ArrayList<WebGroup> groups = new ArrayList<WebGroup>();
        for (Group group : this.getBackingGroups()) {
            groups.add(this.getWebGroup(group));
        }
        return groups;
    }

    @Override
    public WebGroup getGroup(String groupName) {
        return this.getWebGroup(groupName);
    }

    private class ManagedGroup
    extends WebGroup {
        ManagedGroup(Group group) {
            super(group.getName());
            ArrayList<WebUser> users = new ArrayList<WebUser>();
            for (String userId : this.getUsers(group)) {
                users.add(WebRoleManagerImpl.this.getWebUser(userId));
            }
            super.setUsers(users);
        }

        private List<String> getUsers(Group group) {
            return group.getUsers();
        }
    }

    private class ManagedUser
    extends WebUser {
        ManagedUser(User user) {
            super(user.getUserId());
        }
    }

    private class ManagedRole
    extends WebRole {
        private static final int DESCR = 0;
        private static final int USER = 1;
        private static final int GROUP = 2;
        private static final int NAME = 3;
        private final BitSet m_flags;
        private Role m_role;

        ManagedRole() {
            this.m_flags = new BitSet();
        }

        ManagedRole(Role role) {
            super(role.getName());
            this.m_flags = new BitSet();
            this.m_role = role;
            super.setDescription(role.getDescription());
            super.setDefaultUser(WebRoleManagerImpl.this.getWebUser(role.getSupervisor()));
            super.setMembershipGroup(WebRoleManagerImpl.this.getWebGroup(role.getMembershipGroup()));
        }

        ManagedRole(WebRole webRole) {
            super(webRole.getName());
            this.m_flags = new BitSet();
            super.setDescription(webRole.getDescription());
            super.setDefaultUser(webRole.getDefaultUser());
            super.setMembershipGroup(webRole.getMembershipGroup());
        }

        @Override
        public void setDescription(String description) {
            super.setDescription(description);
            this.m_flags.set(0);
        }

        @Override
        public void setDefaultUser(WebUser defaultUser) {
            super.setDefaultUser(defaultUser);
            this.m_flags.set(1);
        }

        @Override
        public void setMembershipGroup(WebGroup memberShipGroup) {
            super.setMembershipGroup(memberShipGroup);
            this.m_flags.set(2);
        }

        @Override
        public void setName(String name) {
            super.setName(name);
            this.m_flags.set(3);
        }

        public void save() {
            try {
                Role role;
                Role role2 = role = this.m_role == null ? new Role() : this.m_role;
                if (this.m_flags.get(0)) {
                    role.setDescription(super.getDescription());
                }
                if (this.m_flags.get(1)) {
                    role.setSupervisor(super.getDefaultUser().getName());
                }
                if (this.m_flags.get(2)) {
                    role.setMembershipGroup(super.getMembershipGroup().getName());
                }
                if (this.m_flags.get(3)) {
                    role.setName(super.getName());
                }
                Collection<WebSchedEntry> newEntries = this.getNewEntries();
                for (WebSchedEntry entry : newEntries) {
                    entry.update(role);
                }
                if (this.m_role != null) {
                    WebRoleManagerImpl.this.m_groupManager.saveGroups();
                } else {
                    WebRoleManagerImpl.this.m_groupManager.saveRole(role);
                    this.m_role = role;
                }
            }
            catch (Throwable e) {
                throw new WebRolesException("Unable to save role " + this.getName() + ". " + e.getMessage(), e);
            }
        }

        @Override
        public Collection<WebUser> getCurrentUsers() {
            if (this.m_role == null) {
                return new ArrayList<WebUser>(0);
            }
            return WebRoleManagerImpl.this.getUsersScheduleForRole(this, new Date());
        }

        @Override
        public WebCalendar getCalendar(Date month) {
            return new MonthlyCalendar(month, this.m_role, WebRoleManagerImpl.this.m_groupManager);
        }

        @Override
        public Schedule getSchedule(int schedIndex) {
            int index = schedIndex;
            return (Schedule)this.m_role.getSchedules().get(index);
        }

        @Override
        public Time getTime(int schedIndex, int timeIndex) {
            int index = timeIndex;
            return (Time)this.getSchedule(schedIndex).getTimes().get(index);
        }
    }

    private static class InvalidGroup
    extends WebGroup {
        public InvalidGroup(String name) {
            super(name);
            super.setUsers(new ArrayList<WebUser>());
        }

        @Override
        public String toString() {
            return "Invalid Group [" + this.getName() + "]";
        }
    }

    private static class InvalidUser
    extends WebUser {
        public InvalidUser(String name) {
            super(name);
        }

        @Override
        public String toString() {
            return "Invalid User [" + this.getName() + "]";
        }
    }
}

