/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.vmware;

import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.PerfCounterInfo;
import com.vmware.vim25.PerfEntityMetric;
import com.vmware.vim25.PerfEntityMetricBase;
import com.vmware.vim25.PerfMetricIntSeries;
import com.vmware.vim25.PerfMetricSeries;
import com.vmware.vim25.PerfQuerySpec;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.PerformanceManager;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.util.MorUtil;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class VmwareConfigBuilder {
    private String hostname;
    private String username;
    private String password;
    private ServiceInstance serviceInstance;
    private PerformanceManager performanceManager;
    private Map<String, Map<String, TreeSet<VMwareConfigMetric>>> collections = new HashMap<String, Map<String, TreeSet<VMwareConfigMetric>>>();
    private Map<Integer, PerfCounterInfo> perfCounterInfoMap = new HashMap<Integer, PerfCounterInfo>();
    private String versionInformation = "";
    private String apiVersion = "";

    public VmwareConfigBuilder(String hostname, String username, String password) {
        this.hostname = hostname;
        this.username = username;
        this.password = password;
    }

    private String getHumanReadableName(PerfCounterInfo perfCounterInfo) {
        return perfCounterInfo.getGroupInfo().getKey() + "." + perfCounterInfo.getNameInfo().getKey() + "." + perfCounterInfo.getRollupType().toString();
    }

    private String normalizeName(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private String normalizeGroupName(String groupName) {
        String modifiedGroupName = groupName;
        String[] groupChunks = new String[]{"sys", "rescpu", "cpu", "net", "disk", "mem", "managementAgent", "virtualDisk", "datastore", "storageAdapter", "storagePath", "hbr", "power"};
        String[] groupReplacements = new String[]{"Sys", "ResCpu", "Cpu", "Net", "Disk", "Mem", "MgtAgt", "VrtDisk", "DaSt", "StAdptr", "StPth", "Hbr", "Power"};
        for (int i = 0; i < groupChunks.length; ++i) {
            modifiedGroupName = modifiedGroupName.replace(groupChunks[i], groupReplacements[i]);
        }
        return modifiedGroupName;
    }

    private String condenseName(String text, String chunk) {
        String ignoreCaseChunk = "[" + chunk.substring(0, 1) + chunk.substring(0, 1).toUpperCase() + "]" + chunk.substring(1);
        String replacement = chunk.substring(0, 1).toUpperCase() + chunk.substring(chunk.length() - 1);
        return text.replaceAll(ignoreCaseChunk, replacement);
    }

    private String getAliasName(PerfCounterInfo perfCounterInfo) {
        String[] nameChunks;
        String group = perfCounterInfo.getGroupInfo().getKey();
        String name = perfCounterInfo.getNameInfo().getKey();
        String rollup = perfCounterInfo.getRollupType().toString();
        group = this.normalizeGroupName(group);
        String[] rollupChunks = new String[]{"summation", "average", "latest", "none", "minimum", "maximum", "total"};
        String[] rollupReplacements = new String[]{"Sum", "Avg", "Lat", "Non", "Min", "Max", "Tot"};
        for (int i = 0; i < rollupChunks.length; ++i) {
            rollup = rollup.replace(rollupChunks[i], rollupReplacements[i]);
        }
        for (String chunk : nameChunks = new String[]{"unkown", "protos", "threshold", "datastore", "alloc", "utilization", "normalized", "normal", "shares", "depth", "resource", "overhead", "swap", "rate", "metric", "number", "averaged", "load", "decompression", "compression", "device", "latency", "capacity", "commands", "target", "aborted", "kernel", "unreserved", "reserved", "total", "read", "write", "queue", "limited", "sample", "count", "touched", "percentage", "seeks", "consumed", "medium", "small", "large", "active", "observed", "time"}) {
            name = this.condenseName(name, chunk);
        }
        name = this.normalizeName(name);
        String full = group + name + rollup;
        if (full.length() >= 19) {
            System.out.println("******************************************");
            System.out.println("Key '" + full + "' is " + full.length() + " characters long");
            System.out.println("******************************************");
        }
        return full;
    }

    private void lookupMetrics(String collectionName, String managedObjectId) throws Exception {
        ManagedObjectReference managedObjectReference = new ManagedObjectReference();
        managedObjectReference.setType("ManagedEntity");
        managedObjectReference.setVal(managedObjectId);
        ManagedEntity managedEntity = MorUtil.createExactManagedEntity((ServerConnection)this.serviceInstance.getServerConnection(), (ManagedObjectReference)managedObjectReference);
        int refreshRate = this.performanceManager.queryPerfProviderSummary(managedEntity).getRefreshRate();
        PerfQuerySpec perfQuerySpec = new PerfQuerySpec();
        perfQuerySpec.setEntity(managedEntity.getMOR());
        perfQuerySpec.setMaxSample(Integer.valueOf(1));
        perfQuerySpec.setIntervalId(Integer.valueOf(refreshRate));
        PerfEntityMetricBase[] perfEntityMetricBases = this.performanceManager.queryPerf(new PerfQuerySpec[]{perfQuerySpec});
        HashMap groupMap = new HashMap();
        HashMap<String, Boolean> multiInstance = new HashMap<String, Boolean>();
        if (perfEntityMetricBases != null) {
            for (int i = 0; i < perfEntityMetricBases.length; ++i) {
                PerfMetricSeries[] perfMetricSeries = ((PerfEntityMetric)perfEntityMetricBases[i]).getValue();
                for (int j = 0; perfMetricSeries != null && j < perfMetricSeries.length; ++j) {
                    long[] longs;
                    if (!(perfMetricSeries[j] instanceof PerfMetricIntSeries) || (longs = ((PerfMetricIntSeries)perfMetricSeries[j]).getValue()).length != 1) continue;
                    PerfCounterInfo perfCounterInfo = this.perfCounterInfoMap.get(perfMetricSeries[j].getId().getCounterId());
                    String instanceName = perfMetricSeries[j].getId().getInstance();
                    String humanReadableName = this.getHumanReadableName(perfCounterInfo);
                    String aliasName = this.getAliasName(perfCounterInfo);
                    String groupName = perfCounterInfo.getGroupInfo().getKey();
                    String normalizedGroupName = this.normalizeGroupName(groupName);
                    Boolean b = (Boolean)multiInstance.get(this.getHumanReadableName(perfCounterInfo));
                    b = b == null ? Boolean.valueOf(instanceName != null && !"".equals(instanceName)) : Boolean.valueOf(b != false || instanceName != null && !"".equals(instanceName));
                    if (!b.booleanValue()) {
                        groupName = "Node";
                        normalizedGroupName = "Node";
                    }
                    if (!groupMap.containsKey(normalizedGroupName)) {
                        groupMap.put(normalizedGroupName, new TreeSet());
                    }
                    TreeSet counterSet = (TreeSet)groupMap.get(normalizedGroupName);
                    multiInstance.put(this.getHumanReadableName(perfCounterInfo), b);
                    counterSet.add(new VMwareConfigMetric(perfCounterInfo, humanReadableName, aliasName, b, normalizedGroupName));
                }
            }
        }
        this.collections.put(collectionName, groupMap);
    }

    private void generateData(String rrdRepository) throws Exception {
        ManagedEntity[] hostSystems;
        ManagedEntity[] virtualMachines;
        PerfCounterInfo[] perfCounterInfos;
        this.serviceInstance = new ServiceInstance(new URL("https://" + this.hostname + "/sdk"), this.username, this.password);
        this.performanceManager = this.serviceInstance.getPerformanceManager();
        for (PerfCounterInfo perfCounterInfo : perfCounterInfos = this.performanceManager.getPerfCounter()) {
            this.perfCounterInfoMap.put(perfCounterInfo.getKey(), perfCounterInfo);
        }
        System.out.println("Generating configuration files for '" + this.serviceInstance.getAboutInfo().getFullName() + "' using rrdRepository '" + rrdRepository + "'...");
        StringBuffer buffer = new StringBuffer();
        buffer.append("Configuration file generated for:\n\n");
        buffer.append("Full name.......: " + this.serviceInstance.getAboutInfo().getFullName() + "\n");
        buffer.append("API type........: " + this.serviceInstance.getAboutInfo().getApiType() + "\n");
        buffer.append("API version.....: " + this.serviceInstance.getAboutInfo().getApiVersion() + "\n");
        buffer.append("Product name....: " + this.serviceInstance.getAboutInfo().getLicenseProductName() + "\n");
        buffer.append("Product version.: " + this.serviceInstance.getAboutInfo().getLicenseProductVersion() + "\n");
        buffer.append("OS type.........: " + this.serviceInstance.getAboutInfo().getOsType() + "\n");
        this.versionInformation = buffer.toString();
        String[] arr = this.serviceInstance.getAboutInfo().getApiVersion().split("\\.");
        if (arr.length > 1) {
            this.apiVersion = arr[0];
            if (Integer.valueOf(this.apiVersion) < 4) {
                this.apiVersion = "3";
            }
        }
        if ((virtualMachines = new InventoryNavigator((ManagedEntity)this.serviceInstance.getRootFolder()).searchManagedEntities("VirtualMachine")) != null) {
            if (virtualMachines.length > 0) {
                for (ManagedEntity managedEntity : virtualMachines) {
                    if (!"poweredOn".equals(((VirtualMachine)managedEntity).getRuntime().getPowerState().toString())) continue;
                    this.lookupMetrics("default-VirtualMachine" + this.apiVersion, managedEntity.getMOR().getVal());
                    break;
                }
            } else {
                System.err.println("No virtual machines found");
            }
        }
        if ((hostSystems = new InventoryNavigator((ManagedEntity)this.serviceInstance.getRootFolder()).searchManagedEntities("HostSystem")) != null) {
            if (hostSystems.length > 0) {
                for (ManagedEntity managedEntity : hostSystems) {
                    if (!"poweredOn".equals(((HostSystem)managedEntity).getRuntime().getPowerState().toString())) continue;
                    this.lookupMetrics("default-HostSystem" + this.apiVersion, managedEntity.getMOR().getVal());
                    break;
                }
            } else {
                System.err.println("No host systems found!");
            }
        }
        this.saveVMwareDatacollectionConfig(rrdRepository);
        this.saveVMwareDatacollectionInclude();
        this.saveVMwareGraphProperties();
    }

    private void saveVMwareGraphProperties() {
        StringBuffer buffer = new StringBuffer();
        StringBuffer include = new StringBuffer();
        HashMap<String, Boolean> generatedGraphs = new HashMap<String, Boolean>();
        for (String collectionName : this.collections.keySet()) {
            Map<String, TreeSet<VMwareConfigMetric>> collection = this.collections.get(collectionName);
            for (String groupName : collection.keySet()) {
                TreeSet<VMwareConfigMetric> metrics = collection.get(groupName);
                for (VMwareConfigMetric vmwarePerformanceMetric : metrics) {
                    Boolean generated = generatedGraphs.get(vmwarePerformanceMetric.getAliasName()) == null ? Boolean.valueOf(false) : (Boolean)generatedGraphs.get(vmwarePerformanceMetric.getAliasName());
                    if (generated.booleanValue()) continue;
                    generatedGraphs.put(vmwarePerformanceMetric.getAliasName(), Boolean.TRUE);
                    buffer.append(vmwarePerformanceMetric.getGraphDefinition(this.apiVersion));
                    include.append(vmwarePerformanceMetric.getInclude(this.apiVersion));
                }
            }
        }
        String content = include.toString();
        this.saveFile("vmware" + this.apiVersion + "-graph-simple.properties", "reports=" + content.subSequence(0, content.length() - 4) + "\n\n" + buffer.toString());
    }

    private void saveFile(String filename, String contents) {
        System.out.println("Saving file '" + filename + "'...");
        try {
            FileWriter f = new FileWriter(filename);
            f.write(contents);
            f.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveVMwareDatacollectionInclude() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\"?>\n");
        buffer.append("\n<!--\n");
        buffer.append(this.versionInformation);
        buffer.append("-->\n\n");
        buffer.append("<datacollection-group name=\"VMware" + this.apiVersion + "\">\n\n");
        TreeSet<String> groupNames = new TreeSet<String>();
        for (String collectionName : this.collections.keySet()) {
            Map<String, TreeSet<VMwareConfigMetric>> collection = this.collections.get(collectionName);
            groupNames.addAll(collection.keySet());
        }
        for (String groupName : groupNames) {
            if ("node".equalsIgnoreCase(groupName)) continue;
            buffer.append("  <resourceType name=\"vmware" + this.apiVersion + groupName + "\" label=\"VMware v" + this.apiVersion + " " + groupName + "\" resourceLabel=\"${vmware" + this.apiVersion + groupName + "Name}\">\n");
            buffer.append("    <persistenceSelectorStrategy class=\"org.opennms.netmgt.collection.support.PersistAllSelectorStrategy\"/>\n");
            buffer.append("    <storageStrategy class=\"org.opennms.netmgt.collection.support.IndexStorageStrategy\"/>\n");
            buffer.append("  </resourceType>\n\n");
        }
        buffer.append("</datacollection-group>");
        this.saveFile("vmware" + this.apiVersion + ".xml", buffer.toString());
    }

    private void saveVMwareDatacollectionConfig(String rrdRepository) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\"?>\n");
        buffer.append("\n<!--\n");
        buffer.append(this.versionInformation);
        buffer.append("-->\n\n");
        buffer.append("<vmware-datacollection-config rrdRepository=\"" + rrdRepository + "\">\n");
        for (String collectionName : this.collections.keySet()) {
            Map<String, TreeSet<VMwareConfigMetric>> collection = this.collections.get(collectionName);
            buffer.append("  <vmware-collection name=\"" + collectionName + "\">\n");
            buffer.append("    <rrd step=\"300\">\n");
            buffer.append("      <rra>RRA:AVERAGE:0.5:1:2016</rra>\n");
            buffer.append("      <rra>RRA:AVERAGE:0.5:12:1488</rra>\n");
            buffer.append("      <rra>RRA:AVERAGE:0.5:288:366</rra>\n");
            buffer.append("      <rra>RRA:MAX:0.5:288:366</rra>\n");
            buffer.append("      <rra>RRA:MIN:0.5:288:366</rra>\n");
            buffer.append("    </rrd>\n");
            buffer.append("    <vmware-groups>\n");
            for (String groupName : collection.keySet()) {
                if ("node".equalsIgnoreCase(groupName)) {
                    buffer.append("      <vmware-group name=\"vmware" + this.apiVersion + groupName + "\" resourceType=\"" + groupName + "\">\n");
                } else {
                    buffer.append("      <vmware-group name=\"vmware" + this.apiVersion + groupName + "\" resourceType=\"vmware" + this.apiVersion + groupName + "\">\n");
                }
                TreeSet<VMwareConfigMetric> metrics = collection.get(groupName);
                for (VMwareConfigMetric vmwarePerformanceMetric : metrics) {
                    buffer.append(vmwarePerformanceMetric.getDatacollectionEntry());
                }
                buffer.append("      </vmware-group>\n");
            }
            buffer.append("    </vmware-groups>\n");
            buffer.append("  </vmware-collection>\n");
        }
        buffer.append("</vmware-datacollection-config>\n");
        this.saveFile("vmware" + this.apiVersion + "-datacollection-config.xml", buffer.toString());
    }

    private static void usage(Options options, CommandLine cmd, String error, Exception e) {
        HelpFormatter formatter = new HelpFormatter();
        PrintWriter pw = new PrintWriter(System.out);
        if (error != null) {
            pw.println("An error occurred: " + error + "\n");
        }
        formatter.printHelp("Usage: VmwareConfigBuilder <hostname> <username> <password>", options);
        if (e != null) {
            pw.println(e.getMessage());
            e.printStackTrace(pw);
        }
        pw.close();
    }

    private static void usage(Options options, CommandLine cmd) {
        VmwareConfigBuilder.usage(options, cmd, null, null);
    }

    public static void main(String[] args) throws ParseException {
        String hostname = null;
        String username = null;
        String password = null;
        String rrdRepository = null;
        Options options = new Options();
        options.addOption("rrdRepository", true, "set rrdRepository path for generated config files, default: '/opt/opennms/share/rrd/snmp/'");
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        List arguments = cmd.getArgList();
        if (arguments.size() < 3) {
            VmwareConfigBuilder.usage(options, cmd);
            System.exit(1);
        }
        hostname = (String)arguments.remove(0);
        username = (String)arguments.remove(0);
        password = (String)arguments.remove(0);
        rrdRepository = cmd.hasOption("rrdRepository") ? cmd.getOptionValue("rrdRepository") : "/opt/opennms/share/rrd/snmp/";
        TrustManager[] trustAllCerts = new TrustManager[]{new TrustAllManager()};
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, null);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier hv = new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
        VmwareConfigBuilder vmwareConfigBuilder = new VmwareConfigBuilder(hostname, username, password);
        try {
            vmwareConfigBuilder.generateData(rrdRepository);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class TrustAllManager
    implements TrustManager,
    X509TrustManager {
        private TrustAllManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public boolean isServerTrusted(X509Certificate[] certs) {
            return true;
        }

        public boolean isClientTrusted(X509Certificate[] certs) {
            return true;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }

    private static class VMwareConfigMetric
    implements Comparable<VMwareConfigMetric> {
        private String humanReadableName;
        private String aliasName;
        private String groupName;
        private PerfCounterInfo perfCounterInfo;
        private boolean multiInstance = false;

        public VMwareConfigMetric(PerfCounterInfo perfCounterInfo, String humanReadableName, String aliasName, boolean multiInstance, String groupName) {
            this.perfCounterInfo = perfCounterInfo;
            this.humanReadableName = humanReadableName;
            this.aliasName = aliasName;
            this.multiInstance = multiInstance;
            this.groupName = groupName;
        }

        public String getDatacollectionEntry() {
            return "        <attrib name=\"" + this.humanReadableName + "\" alias=\"" + this.aliasName + "\" type=\"Gauge\"/>\n";
        }

        public String getGraphDefinition(String apiVersion) {
            String resourceType = this.multiInstance ? "vmware" + apiVersion + this.groupName : "nodeSnmp";
            String def = "report.vmware" + apiVersion + "." + this.aliasName + ".name=vmware" + apiVersion + "." + this.humanReadableName + "\n" + "report.vmware" + apiVersion + "." + this.aliasName + ".columns=" + this.aliasName + "\n";
            if (this.multiInstance) {
                def = def + "report.vmware" + apiVersion + "." + this.aliasName + ".propertiesValues=vmware" + apiVersion + this.groupName + "Name\n";
            }
            def = def + "report.vmware" + apiVersion + "." + this.aliasName + ".type=" + resourceType + "\n" + "report.vmware" + apiVersion + "." + this.aliasName + ".command=--title=\"VMWare" + apiVersion + " " + this.humanReadableName + (this.multiInstance ? " {" + resourceType + "Name}" : "") + "\" \\\n" + "--vertical-label=\"" + this.aliasName + "\" \\\n" + "DEF:xxx={rrd1}:" + this.aliasName + ":AVERAGE \\\n" + "LINE2:xxx#0000ff:\"" + this.aliasName + "\" \\\n" + "GPRINT:xxx:AVERAGE:\"Avg  \\\\: %8.2lf %s\" \\\n" + "GPRINT:xxx:MIN:\"Min  \\\\: %8.2lf %s\" \\\n" + "GPRINT:xxx:MAX:\"Max  \\\\: %8.2lf %s\\\\n\" \n\n";
            return def;
        }

        public String getInclude(String apiVersion) {
            return "vmware" + apiVersion + "." + this.getAliasName() + ", \\\n";
        }

        public String getHumanReadableName() {
            return this.humanReadableName;
        }

        public String getAliasName() {
            return this.aliasName;
        }

        public PerfCounterInfo getPerfCounterInfo() {
            return this.perfCounterInfo;
        }

        public boolean isMultiInstance() {
            return this.multiInstance;
        }

        @Override
        public int compareTo(VMwareConfigMetric o) {
            return this.getAliasName().compareTo(o.getAliasName());
        }
    }
}

