/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.xml.collector;

import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.dto.CollectionSetDTO;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.DeferredGenericTypeResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.protocols.xml.collector.DocumentNamespaceResolver;
import org.opennms.protocols.xml.collector.UrlFactory;
import org.opennms.protocols.xml.collector.XmlCollectionHandler;
import org.opennms.protocols.xml.config.Content;
import org.opennms.protocols.xml.config.Header;
import org.opennms.protocols.xml.config.Parameter;
import org.opennms.protocols.xml.config.Request;
import org.opennms.protocols.xml.config.XmlDataCollection;
import org.opennms.protocols.xml.config.XmlGroup;
import org.opennms.protocols.xml.config.XmlObject;
import org.opennms.protocols.xml.config.XmlSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractXmlCollectionHandler
implements XmlCollectionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractXmlCollectionHandler.class);
    private static final String FALLBACK_RESOURCE_TYPE_NAME = "xmlCollector";
    private String m_serviceName;
    private RrdRepository m_rrdRepository;
    private ResourceStorageDao m_resourceStorageDao;

    public ResourceStorageDao getResourceStorageDao() {
        if (this.m_resourceStorageDao == null) {
            this.m_resourceStorageDao = (ResourceStorageDao)BeanUtils.getBean((String)"daoContext", (String)"resourceStorageDao", ResourceStorageDao.class);
        }
        return this.m_resourceStorageDao;
    }

    public void setResourceStorageDao(ResourceStorageDao resourceStorageDao) {
        this.m_resourceStorageDao = resourceStorageDao;
    }

    @Override
    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    @Override
    public void setRrdRepository(RrdRepository rrdRepository) {
        this.m_rrdRepository = rrdRepository;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public RrdRepository getRrdRepository() {
        return this.m_rrdRepository;
    }

    @Override
    public CollectionSet collect(CollectionAgent agent, XmlDataCollection collection, Map<String, Object> parameters) throws CollectionException {
        CollectionSetDTO collectionSetDTO;
        String status = "finished";
        CollectionSetBuilder builder = new CollectionSetBuilder(agent);
        DateTime startTime = new DateTime();
        try {
            LOG.debug("collect: looping sources for collection {}", (Object)collection.getName());
            for (XmlSource source : collection.getXmlSources()) {
                String urlStr = source.getUrl();
                Request request = source.getRequest();
                LOG.debug("collect: starting source url '{}' collection with request: {}", (Object)urlStr, (Object)request);
                this.fillCollectionSet(urlStr, request, agent, builder, source);
                LOG.debug("collect: finished source url '{}' collection with {} resources", (Object)urlStr, (Object)builder.getNumResources());
            }
            collectionSetDTO = builder.build();
        }
        catch (Exception e) {
            try {
                status = "failed";
                throw new CollectionException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DateTime endTime = new DateTime();
                LOG.debug("collect: {} collection {}: duration: {} ms", new Object[]{status, collection.getName(), endTime.getMillis() - startTime.getMillis()});
                throw throwable;
            }
        }
        DateTime endTime = new DateTime();
        LOG.debug("collect: {} collection {}: duration: {} ms", new Object[]{status, collection.getName(), endTime.getMillis() - startTime.getMillis()});
        return collectionSetDTO;
    }

    protected void fillCollectionSet(CollectionAgent agent, CollectionSetBuilder builder, XmlSource source, org.w3c.dom.Document doc) throws XPathExpressionException, ParseException {
        DocumentNamespaceResolver nc = new DocumentNamespaceResolver(doc);
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(nc);
        for (XmlGroup group : source.getXmlGroups()) {
            LOG.debug("fillCollectionSet: getting resources for XML group {} using XPATH {}", (Object)group.getName(), (Object)group.getResourceXpath());
            Date timestamp = this.getTimeStamp(doc, xpath, group);
            NodeList resourceList = (NodeList)xpath.evaluate(group.getResourceXpath(), doc, XPathConstants.NODESET);
            for (int j = 0; j < resourceList.getLength(); ++j) {
                Node resource = resourceList.item(j);
                String resourceName = this.getResourceName(xpath, group, resource);
                Resource collectionResource = this.getCollectionResource(agent, resourceName, group.getResourceType(), timestamp);
                LOG.debug("fillCollectionSet: processing resource {}", (Object)collectionResource);
                for (XmlObject object : group.getXmlObjects()) {
                    String value = (String)xpath.evaluate(object.getXpath(), resource, XPathConstants.STRING);
                    builder.withAttribute(collectionResource, group.getName(), object.getName(), value, object.getDataType());
                }
                this.processXmlResource(builder, collectionResource, resourceName, group.getName());
            }
        }
        LOG.debug("fillCollectionSet: finishing collection set with {} resources and {} attributes on {}", new Object[]{builder.getNumResources(), builder.getNumAttributes(), agent});
    }

    private String getResourceName(XPath xpath, XmlGroup group, Node resource) throws XPathExpressionException {
        if (group.hasMultipleResourceKey()) {
            ArrayList<String> keys = new ArrayList<String>();
            for (String key : group.getXmlResourceKey().getKeyXpathList()) {
                LOG.debug("getResourceName: getting key for resource's name using {}", (Object)key);
                Node keyNode = (Node)xpath.evaluate(key, resource, XPathConstants.NODE);
                keys.add(keyNode.getNodeValue() == null ? keyNode.getTextContent() : keyNode.getNodeValue());
            }
            return StringUtils.join(keys, (String)"_");
        }
        if (group.getKeyXpath() == null) {
            LOG.debug("getResourceName: assuming node level resource");
            return "node";
        }
        LOG.debug("getResourceName: getting key for resource's name using {}", (Object)group.getKeyXpath());
        Node keyNode = (Node)xpath.evaluate(group.getKeyXpath(), resource, XPathConstants.NODE);
        return keyNode.getNodeValue() == null ? keyNode.getTextContent() : keyNode.getNodeValue();
    }

    protected abstract void fillCollectionSet(String var1, Request var2, CollectionAgent var3, CollectionSetBuilder var4, XmlSource var5) throws Exception;

    protected abstract void processXmlResource(CollectionSetBuilder var1, Resource var2, String var3, String var4);

    protected Resource getCollectionResource(CollectionAgent agent, String instance, String resourceType, Date timestamp) {
        NodeLevelResource nodeResource = new NodeLevelResource(agent.getNodeId());
        if ("node".equalsIgnoreCase(resourceType)) {
            return nodeResource;
        }
        DeferredGenericTypeResource resource = new DeferredGenericTypeResource(nodeResource, resourceType, FALLBACK_RESOURCE_TYPE_NAME, instance);
        if (timestamp != null) {
            LOG.debug("getCollectionResource: the date that will be used when updating the RRDs is {}", (Object)timestamp);
            resource.setTimestamp(timestamp);
        }
        return resource;
    }

    protected Date getTimeStamp(org.w3c.dom.Document doc, XPath xpath, XmlGroup group) throws XPathExpressionException {
        if (group.getTimestampXpath() == null) {
            return null;
        }
        String pattern = group.getTimestampFormat() == null ? "yyyy-MM-dd HH:mm:ss" : group.getTimestampFormat();
        LOG.debug("getTimeStamp: retrieving custom timestamp to be used when updating RRDs using XPATH {} and pattern {}", (Object)group.getTimestampXpath(), (Object)pattern);
        Node tsNode = (Node)xpath.evaluate(group.getTimestampXpath(), doc, XPathConstants.NODE);
        if (tsNode == null) {
            LOG.warn("getTimeStamp: can't find the custom timestamp using XPATH {}", (Object)group.getTimestampXpath());
            return null;
        }
        Date date = null;
        String value = tsNode.getNodeValue() == null ? tsNode.getTextContent() : tsNode.getNodeValue();
        LOG.debug("getTimeStamp: time stamp value is {}", (Object)value);
        try {
            DateTimeFormatter dtf = DateTimeFormat.forPattern((String)pattern);
            DateTime dateTime = dtf.parseDateTime(value);
            date = dateTime.toDate();
        }
        catch (Exception e) {
            LOG.warn("getTimeStamp: can't convert custom timetime {} using pattern {}", (Object)value, (Object)pattern);
        }
        return date;
    }

    @Override
    public String parseUrl(NodeDao nodeDao, String unformattedUrl, CollectionAgent agent, Integer collectionStep) throws IllegalArgumentException {
        OnmsNode node = (OnmsNode)nodeDao.get((Serializable)Integer.valueOf(agent.getNodeId()));
        return AbstractXmlCollectionHandler.parseString("URL", unformattedUrl, node, agent.getHostAddress(), collectionStep);
    }

    @Override
    public Request parseRequest(NodeDao nodeDao, Request unformattedRequest, CollectionAgent agent, Integer collectionStep) throws IllegalArgumentException {
        if (unformattedRequest == null) {
            return null;
        }
        OnmsNode node = (OnmsNode)nodeDao.get((Serializable)Integer.valueOf(agent.getNodeId()));
        Request request = new Request();
        request.setMethod(unformattedRequest.getMethod());
        for (Header header : unformattedRequest.getHeaders()) {
            request.addHeader(header.getName(), AbstractXmlCollectionHandler.parseString(header.getName(), header.getValue(), node, agent.getHostAddress(), collectionStep));
        }
        for (Parameter param : unformattedRequest.getParameters()) {
            request.addParameter(param.getName(), AbstractXmlCollectionHandler.parseString(param.getName(), param.getValue(), node, agent.getHostAddress(), collectionStep));
        }
        Content cnt = unformattedRequest.getContent();
        if (cnt != null) {
            request.setContent(new Content(cnt.getType(), AbstractXmlCollectionHandler.parseString("Content", cnt.getData(), node, agent.getHostAddress(), collectionStep)));
        }
        return request;
    }

    protected static String parseString(String reference, String unformattedString, OnmsNode node, String ipAddress, Integer collectionStep) throws IllegalArgumentException {
        if (unformattedString == null || node == null) {
            return null;
        }
        String formattedString = unformattedString.replaceAll("[{](?i)(ipAddr|ipAddress)[}]", ipAddress);
        formattedString = formattedString.replaceAll("[{](?i)step[}]", collectionStep.toString());
        formattedString = formattedString.replaceAll("[{](?i)nodeId[}]", node.getNodeId());
        if (node.getLabel() != null) {
            formattedString = formattedString.replaceAll("[{](?i)nodeLabel[}]", node.getLabel());
        }
        if (node.getForeignId() != null) {
            formattedString = formattedString.replaceAll("[{](?i)foreignId[}]", node.getForeignId());
        }
        if (node.getForeignSource() != null) {
            formattedString = formattedString.replaceAll("[{](?i)foreignSource[}]", node.getForeignSource());
        }
        if (node.getAssetRecord() != null) {
            BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)node.getAssetRecord());
            for (PropertyDescriptor p : wrapper.getPropertyDescriptors()) {
                Object obj = wrapper.getPropertyValue(p.getName());
                if (obj == null) continue;
                String objStr = obj.toString();
                try {
                    objStr = URLEncoder.encode(obj.toString(), StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                formattedString = formattedString.replaceAll("[{](?i)" + p.getName() + "[}]", objStr);
            }
        }
        if (formattedString.matches(".*[{].+[}].*")) {
            throw new IllegalArgumentException("The " + reference + " " + formattedString + " contains unknown placeholders.");
        }
        return formattedString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected org.w3c.dom.Document getXmlDocument(String urlString, Request request) throws Exception {
        org.w3c.dom.Document document;
        InputStream is = null;
        URLConnection c = null;
        try {
            org.w3c.dom.Document doc;
            URL url = UrlFactory.getUrl(urlString, request);
            c = url.openConnection();
            is = c.getInputStream();
            document = doc = this.getXmlDocument(is, request);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            UrlFactory.disconnect(c);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        UrlFactory.disconnect(c);
        return document;
    }

    protected org.w3c.dom.Document getXmlDocument(InputStream is, Request request) throws Exception {
        is = this.preProcessHtml(request, is);
        is = this.applyXsltTransformation(request, is);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)is, (Writer)writer, (Charset)StandardCharsets.UTF_8);
        String contents = writer.toString();
        org.w3c.dom.Document doc = builder.parse(IOUtils.toInputStream((String)contents, (Charset)StandardCharsets.UTF_8));
        if (doc.getNamespaceURI() != null && doc.getPrefix() == null) {
            factory.setNamespaceAware(false);
            builder = factory.newDocumentBuilder();
            doc = builder.parse(IOUtils.toInputStream((String)contents, (Charset)StandardCharsets.UTF_8));
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream applyXsltTransformation(Request request, InputStream is) throws Exception {
        if (request == null || is == null) {
            return is;
        }
        String xsltFilename = request.getParameter("xslt-source-file");
        if (xsltFilename == null) {
            return is;
        }
        File xsltFile = new File(xsltFilename);
        if (!xsltFile.exists()) {
            return is;
        }
        TransformerFactory factory = TransformerFactory.newInstance();
        StreamSource xslt = new StreamSource(xsltFile);
        Transformer transformer = factory.newTransformer(xslt);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            transformer.transform(new StreamSource(is), new StreamResult(baos));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream preProcessHtml(Request request, InputStream is) throws IOException {
        if (request == null || is == null || !Boolean.parseBoolean(request.getParameter("pre-parse-html"))) {
            return is;
        }
        try {
            Document doc = Jsoup.parse((InputStream)is, (String)"ISO-8859-9", (String)"/");
            doc.outputSettings().escapeMode(Entities.EscapeMode.xhtml);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(doc.outerHtml().getBytes());
            return byteArrayInputStream;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }
}

