/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collectd.wmi.WmiAgentState;
import org.opennms.netmgt.collection.api.AbstractRemoteServiceCollector;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.support.IndexStorageStrategy;
import org.opennms.netmgt.collection.support.PersistAllSelectorStrategy;
import org.opennms.netmgt.collection.support.builder.CollectionSetBuilder;
import org.opennms.netmgt.collection.support.builder.GenericTypeResource;
import org.opennms.netmgt.collection.support.builder.NodeLevelResource;
import org.opennms.netmgt.collection.support.builder.Resource;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.WmiDataCollectionConfigFactory;
import org.opennms.netmgt.config.WmiPeerFactory;
import org.opennms.netmgt.config.datacollection.PersistenceSelectorStrategy;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.datacollection.StorageStrategy;
import org.opennms.netmgt.config.wmi.Attrib;
import org.opennms.netmgt.config.wmi.WmiAgentConfig;
import org.opennms.netmgt.config.wmi.WmiCollection;
import org.opennms.netmgt.config.wmi.Wpm;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.protocols.wmi.WmiClient;
import org.opennms.protocols.wmi.WmiException;
import org.opennms.protocols.wmi.WmiManager;
import org.opennms.protocols.wmi.WmiParams;
import org.opennms.protocols.wmi.WmiResult;
import org.opennms.protocols.wmi.wbem.OnmsWbemObject;
import org.opennms.protocols.wmi.wbem.OnmsWbemObjectSet;
import org.opennms.protocols.wmi.wbem.OnmsWbemProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WmiCollector
extends AbstractRemoteServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(WmiCollector.class);
    private static final String WMI_COLLECTION_KEY = "wmiCollection";
    private static final String WMI_AGENT_CONFIG_KEY = "wmiAgentConfig";
    private static final Map<String, Class<?>> TYPE_MAP = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, Class<WmiCollection>>("wmiCollection", WmiCollection.class), new AbstractMap.SimpleEntry<String, Class<WmiAgentConfig>>("wmiAgentConfig", WmiAgentConfig.class)).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Class)e.getValue())));

    public WmiCollector() {
        super(TYPE_MAP);
    }

    public void initialize() {
        LOG.debug("initialize: Initializing WmiCollector.");
        this.initWMIPeerFactory();
        this.initWMICollectionConfig();
    }

    public Map<String, Object> getRuntimeAttributes(CollectionAgent agent, Map<String, Object> parameters) {
        HashMap<String, Object> runtimeAttributes = new HashMap<String, Object>();
        String collectionName = ParameterMap.getKeyedString(parameters, (String)"collection", (String)ParameterMap.getKeyedString(parameters, (String)"wmi-collection", null));
        WmiCollection collection = WmiDataCollectionConfigFactory.getInstance().getWmiCollection(collectionName);
        runtimeAttributes.put(WMI_COLLECTION_KEY, collection);
        WmiAgentConfig agentConfig = WmiPeerFactory.getInstance().getAgentConfig((InetAddress)agent.getAddress());
        runtimeAttributes.put(WMI_AGENT_CONFIG_KEY, agentConfig);
        return runtimeAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionSet collect(CollectionAgent agent, Map<String, Object> parameters) {
        WmiCollection collection = (WmiCollection)parameters.get(WMI_COLLECTION_KEY);
        WmiAgentConfig agentConfig = (WmiAgentConfig)parameters.get(WMI_AGENT_CONFIG_KEY);
        WmiAgentState agentState = new WmiAgentState((InetAddress)agent.getAddress(), agentConfig, parameters);
        CollectionSetBuilder builder = new CollectionSetBuilder(agent).withStatus(CollectionStatus.FAILED);
        if (collection.getWpms().getWpm().size() < 1) {
            LOG.info("No groups to collect.");
            return builder.withStatus(CollectionStatus.SUCCEEDED).build();
        }
        NodeLevelResource nodeResource = new NodeLevelResource(agent.getNodeId());
        for (Wpm wpm : collection.getWpms().getWpm()) {
            if (agentState.shouldCheckAvailability(wpm.getName(), wpm.getRecheckInterval()) && !this.isGroupAvailable(agentState, wpm) || !agentState.groupIsAvailable(wpm.getName())) continue;
            WmiClient client = null;
            try {
                agentState.connect(wpm.getWmiNamespace());
                client = (WmiClient)agentState.getWmiClient();
                OnmsWbemObjectSet wOS = client.performInstanceOf(wpm.getWmiClass());
                if (wOS != null) {
                    for (int i = 0; i < wOS.count(); ++i) {
                        NodeLevelResource resource = null;
                        OnmsWbemObject obj = wOS.get(i);
                        if (wOS.count() > 1) {
                            OnmsWbemProperty prop = obj.getWmiProperties().getByName(wpm.getKeyvalue());
                            Object propVal = prop.getWmiValue();
                            String instance = null;
                            instance = propVal instanceof String ? (String)propVal : propVal.toString();
                            resource = this.getWmiResource(agent, wpm.getResourceType(), nodeResource, instance);
                        } else {
                            resource = nodeResource;
                        }
                        for (Attrib attrib : wpm.getAttrib()) {
                            OnmsWbemProperty prop = obj.getWmiProperties().getByName(attrib.getWmiObject());
                            AttributeType type = attrib.getType();
                            String stringValue = prop.getWmiValue().toString();
                            if (type.isNumeric()) {
                                Double numericValue = Double.NaN;
                                try {
                                    numericValue = Double.parseDouble(stringValue);
                                }
                                catch (NumberFormatException e) {
                                    LOG.warn("Value '{}' for attribute named '{}' cannot be converted to a number. Skipping.", prop.getWmiValue(), (Object)attrib.getName());
                                    continue;
                                }
                                builder.withNumericAttribute((Resource)resource, wpm.getName(), attrib.getAlias(), (Number)numericValue, type);
                                continue;
                            }
                            builder.withStringAttribute((Resource)resource, wpm.getName(), attrib.getAlias(), stringValue);
                        }
                    }
                }
                builder.withStatus(CollectionStatus.SUCCEEDED);
            }
            catch (WmiException e) {
                LOG.info("unable to collect params for wpm '{}'", (Object)wpm.getName(), (Object)e);
            }
            finally {
                if (client == null) continue;
                try {
                    client.disconnect();
                }
                catch (WmiException e) {
                    LOG.warn("An error occurred disconnecting while collecting from WMI.", (Throwable)e);
                }
            }
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGroupAvailable(WmiAgentState agentState, Wpm wpm) {
        LOG.debug("Checking availability of group {} via object {} of class {} in namespace {}", new Object[]{wpm.getName(), wpm.getKeyvalue(), wpm.getWmiClass(), wpm.getWmiNamespace()});
        WmiManager manager = null;
        try {
            manager = agentState.getManager();
            manager.setNamespace(wpm.getWmiNamespace());
            manager.init();
            WmiParams params = new WmiParams("InstanceOf", "not-applicable", "NOOP", wpm.getWmiClass(), wpm.getKeyvalue());
            WmiResult result = manager.performOp(params);
            boolean isAvailable = result.getResultCode() == 0;
            agentState.setGroupIsAvailable(wpm.getName(), isAvailable);
            LOG.debug("Group {} is {}{}.", new Object[]{wpm.getName(), isAvailable ? "" : "not ", "available"});
        }
        catch (WmiException e) {
            LOG.warn("Error checking group ({}) availability.", (Object)wpm.getName(), (Object)e);
            agentState.setGroupIsAvailable(wpm.getName(), false);
            boolean bl = false;
            return bl;
        }
        finally {
            if (manager != null) {
                try {
                    manager.close();
                }
                catch (WmiException e) {
                    LOG.warn("An error occurred closing the WMI Manager", (Throwable)e);
                }
            }
        }
        return true;
    }

    private Resource getWmiResource(CollectionAgent agent, String resourceType, NodeLevelResource nodeResource, String instance) {
        ResourceType rt = (ResourceType)DataCollectionConfigFactory.getInstance().getConfiguredResourceTypes().get(resourceType);
        if (rt == null) {
            LOG.debug("getWmiResourceType: using default WMI resource type strategy - index / all");
            rt = new ResourceType();
            rt.setName(resourceType);
            rt.setStorageStrategy(new StorageStrategy());
            rt.getStorageStrategy().setClazz(IndexStorageStrategy.class.getName());
            rt.setPersistenceSelectorStrategy(new PersistenceSelectorStrategy());
            rt.getPersistenceSelectorStrategy().setClazz(PersistAllSelectorStrategy.class.getName());
        }
        return new GenericTypeResource(nodeResource, (org.opennms.netmgt.collection.api.ResourceType)rt, instance);
    }

    private void initWMIPeerFactory() {
        LOG.debug("initialize: Initializing WmiPeerFactory");
        try {
            WmiPeerFactory.init();
        }
        catch (MarshalException e) {
            LOG.error("initialize: Error marshalling configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            LOG.error("initialize: Error validating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            LOG.error("initialize: Error reading configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private void initWMICollectionConfig() {
        LOG.debug("initialize: Initializing collector: {}", ((Object)((Object)this)).getClass());
        try {
            WmiDataCollectionConfigFactory.init();
        }
        catch (FileNotFoundException e) {
            LOG.error("initialize: Error locating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            LOG.error("initialize: Error reading configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return WmiDataCollectionConfigFactory.getInstance().getRrdRepository(collectionName);
    }
}

