/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.rpc;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.opennms.core.rpc.api.RpcRequest;
import org.opennms.netmgt.dao.api.MonitoringLocationUtils;
import org.opennms.netmgt.provision.persist.RequisitionProvider;
import org.opennms.netmgt.provision.persist.RequisitionRequest;
import org.opennms.netmgt.provision.persist.RequisitionRequestBuilder;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.rpc.LocationAwareRequisitionClientImpl;
import org.opennms.netmgt.provision.persist.rpc.RequisitionRequestDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequisitionRequestBuilderImpl
implements RequisitionRequestBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(RequisitionRequestBuilderImpl.class);
    public static final String LOCATION_PARAMETER_NAME = "location";
    public static final String TTL_PARAMETER_NAME = "ttl";
    private final LocationAwareRequisitionClientImpl client;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private RequisitionProvider provider;
    private String location;
    private Long ttlInMs;

    public RequisitionRequestBuilderImpl(LocationAwareRequisitionClientImpl client) {
        this.client = Objects.requireNonNull(client);
    }

    public RequisitionRequestBuilder withLocation(String location) {
        this.location = location;
        return this;
    }

    public RequisitionRequestBuilder withRequisitionProviderType(String type) {
        RequisitionProvider provider = this.client.getRegistry().getProviderByType(type);
        if (provider == null) {
            throw new IllegalArgumentException(String.format("No provider found for type '%s'. Avaiable types include: %s", type, this.client.getRegistry().getTypes()));
        }
        this.provider = provider;
        return this;
    }

    public RequisitionRequestBuilder withRequisitionProvider(RequisitionProvider provider) {
        this.provider = provider;
        return this;
    }

    public RequisitionRequestBuilder withParameters(Map<String, String> parameters) {
        this.parameters.putAll(parameters);
        return this;
    }

    public RequisitionRequestBuilder withTimeToLive(Long ttlInMs) {
        this.ttlInMs = ttlInMs;
        return this;
    }

    public CompletableFuture<Requisition> execute() {
        if (this.provider == null) {
            throw new IllegalArgumentException("Provider or provider type is required.");
        }
        RequisitionRequestDTO request = new RequisitionRequestDTO();
        request.setType(this.provider.getType());
        if (this.parameters.containsKey(LOCATION_PARAMETER_NAME)) {
            request.setLocation(this.parameters.get(LOCATION_PARAMETER_NAME));
        }
        if (this.location != null) {
            request.setLocation(this.location);
        }
        if (this.parameters.containsKey(TTL_PARAMETER_NAME)) {
            try {
                Long ttlParam = Long.parseLong(this.parameters.get(TTL_PARAMETER_NAME));
                request.setTimeToLiveMs(ttlParam);
            }
            catch (Throwable t) {
                LOG.warn("Failed to parse TTL from parameter map: {}", this.parameters, (Object)t);
            }
        }
        if (this.ttlInMs != null) {
            request.setTimeToLiveMs(this.ttlInMs);
        }
        RequisitionRequest providerRequest = this.provider.getRequest(this.parameters);
        if (MonitoringLocationUtils.isDefaultLocationName((String)this.location)) {
            request.setProviderRequest(providerRequest);
        } else {
            request.setProviderRequest(this.provider.marshalRequest(providerRequest));
        }
        return this.client.getDelegate().execute((RpcRequest)request).thenApply(results -> results.getRequisition());
    }
}

