/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SyslogdConfig;
import org.opennms.netmgt.syslogd.SinkDispatchingSyslogReceiver;
import org.opennms.netmgt.syslogd.api.SyslogConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogReceiverJavaNetImpl
extends SinkDispatchingSyslogReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogReceiverJavaNetImpl.class);
    private static final MetricRegistry METRICS = new MetricRegistry();
    private static final int SOCKET_TIMEOUT = 500;
    private volatile boolean m_stop;
    private DatagramSocket m_dgSock;
    private Thread m_context;
    private final SyslogdConfig m_config;

    public SyslogReceiverJavaNetImpl(SyslogdConfig config) {
        super(config);
        this.m_config = config;
        this.m_stop = false;
        this.m_dgSock = null;
    }

    @Override
    public String getName() {
        String listenAddress = this.m_config.getListenAddress() != null && this.m_config.getListenAddress().length() > 0 ? this.m_config.getListenAddress() : "0.0.0.0";
        return this.getClass().getSimpleName() + " [" + listenAddress + ":" + this.m_config.getSyslogPort() + "]";
    }

    @Override
    public void stop() throws InterruptedException {
        this.m_stop = true;
        if (this.m_dgSock != null) {
            this.m_dgSock.close();
        }
        if (this.m_context != null) {
            LOG.debug("Stopping and joining thread context {}", (Object)this.m_context.getName());
            this.m_context.interrupt();
            this.m_context.join();
            LOG.debug("Thread context stopped and joined");
        }
        try {
            if (this.m_dispatcher != null) {
                this.m_dispatcher.close();
                this.m_dispatcher = null;
            }
        }
        catch (Exception e) {
            LOG.warn("Exception while closing dispatcher.", (Throwable)e);
        }
    }

    @Override
    public void run() {
        super.run();
        this.m_context = Thread.currentThread();
        Meter packetMeter = METRICS.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"packets"}));
        Histogram packetSizeHistogram = METRICS.histogram(MetricRegistry.name(this.getClass(), (String[])new String[]{"packetSize"}));
        if (this.m_stop) {
            LOG.debug("Stop flag set before thread started, exiting");
            return;
        }
        LOG.debug("Thread context started");
        int length = 65535;
        byte[] buffer = new byte[65535];
        try {
            LOG.debug("Creating syslog socket");
            this.m_dgSock = new DatagramSocket(null);
        }
        catch (SocketException e) {
            LOG.warn("Could not create syslog socket: " + e.getMessage(), (Throwable)e);
            return;
        }
        try {
            LOG.debug("Setting socket timeout to {}ms", (Object)500);
            this.m_dgSock.setSoTimeout(500);
        }
        catch (SocketException e) {
            LOG.warn("An I/O error occured while trying to set the socket timeout", (Throwable)e);
        }
        try {
            LOG.debug("Setting socket SO_REUSEADDR to true");
            this.m_dgSock.setReuseAddress(true);
        }
        catch (SocketException e) {
            LOG.warn("An I/O error occured while trying to set SO_REUSEADDR", (Throwable)e);
        }
        try {
            LOG.debug("Attempting to set receive buffer size to {}", (Object)Integer.MAX_VALUE);
            this.m_dgSock.setReceiveBufferSize(Integer.MAX_VALUE);
            LOG.debug("Actual receive buffer size is {}", (Object)this.m_dgSock.getReceiveBufferSize());
        }
        catch (SocketException e) {
            LOG.info("Failed to set the receive buffer to {}", (Object)Integer.MAX_VALUE, (Object)e);
        }
        try {
            LOG.debug("Opening datagram socket");
            if (this.m_config.getListenAddress() != null && this.m_config.getListenAddress().length() != 0) {
                this.m_dgSock.bind(new InetSocketAddress(InetAddressUtils.addr((String)this.m_config.getListenAddress()), this.m_config.getSyslogPort()));
            } else {
                this.m_dgSock.bind(new InetSocketAddress(this.m_config.getSyslogPort()));
            }
        }
        catch (SocketException e) {
            LOG.info("Failed to open datagram socket", (Throwable)e);
        }
        boolean ioInterrupted = false;
        DatagramPacket pkt = new DatagramPacket(buffer, 65535);
        while (!this.m_stop) {
            if (this.m_context.isInterrupted()) {
                LOG.debug("Thread context interrupted");
                break;
            }
            try {
                if (!ioInterrupted) {
                    LOG.debug("Waiting on a datagram to arrive");
                }
                this.m_dgSock.receive(pkt);
                packetMeter.mark();
                packetSizeHistogram.update(65535);
                SyslogConnection connection = new SyslogConnection(pkt, true);
                this.m_dispatcher.send((Message)connection);
                ioInterrupted = false;
            }
            catch (SocketTimeoutException e) {
                ioInterrupted = true;
            }
            catch (InterruptedIOException e) {
                ioInterrupted = true;
            }
            catch (IOException e) {
                if (this.m_stop) {
                    LOG.debug("Shutting down the datagram receipt port: " + e.getMessage());
                    break;
                }
                LOG.error("An I/O exception occured on the datagram receipt port, exiting", (Throwable)e);
                break;
            }
        }
        LOG.debug("Thread context exiting");
    }
}

