/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal.extender;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.ops4j.pax.web.extender.war.internal.extender.Extension;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExtender
implements BundleActivator,
BundleTrackerCustomizer<Bundle>,
SynchronousBundleListener {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<Bundle, Extension> extensions = new ConcurrentHashMap<Bundle, Extension>();
    private final ConcurrentMap<Bundle, FutureTask<Void>> destroying = new ConcurrentHashMap<Bundle, FutureTask<Void>>();
    private volatile boolean stopping;
    private volatile boolean stopped;
    private boolean synchronous;
    private boolean preemptiveShutdown;
    private BundleContext bundleContext;
    private ExecutorService executors;
    private BundleTracker<Bundle> tracker;

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public boolean isPreemptiveShutdown() {
        return this.preemptiveShutdown;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public ExecutorService getExecutors() {
        return this.executors;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public void setPreemptiveShutdown(boolean preemptiveShutdown) {
        this.preemptiveShutdown = preemptiveShutdown;
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.bundleContext.addBundleListener((BundleListener)this);
        this.tracker = new BundleTracker(this.bundleContext, 40, (BundleTrackerCustomizer)this);
        if (!this.synchronous) {
            this.executors = this.createExecutor();
        }
        this.doStart();
    }

    public void stop(BundleContext context) throws Exception {
        this.stopping = true;
        while (!this.extensions.isEmpty()) {
            Collection<Bundle> toDestroy = this.chooseBundlesToDestroy(this.extensions.keySet());
            if (toDestroy == null || toDestroy.isEmpty()) {
                toDestroy = new ArrayList(this.extensions.keySet());
            }
            for (Bundle bundle : toDestroy) {
                this.destroyExtension(bundle);
            }
        }
        this.doStop();
        if (this.executors != null) {
            this.executors.shutdown();
            try {
                this.executors.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.executors = null;
        }
        this.stopped = true;
    }

    protected void doStart() throws Exception {
        this.startTracking();
    }

    protected void doStop() throws Exception {
        this.stopTracking();
    }

    protected void startTracking() {
        this.tracker.open();
    }

    protected void stopTracking() {
        this.tracker.close();
    }

    protected ExecutorService createExecutor() {
        return Executors.newScheduledThreadPool(3);
    }

    protected Collection<Bundle> chooseBundlesToDestroy(Set<Bundle> bundles) {
        return null;
    }

    public void bundleChanged(BundleEvent event) {
        if (this.stopped) {
            return;
        }
        Bundle bundle = event.getBundle();
        if (bundle.getState() != 32 && bundle.getState() != 8 && bundle != this.bundleContext.getBundle()) {
            this.destroyExtension(bundle);
        }
    }

    public Bundle addingBundle(Bundle bundle, BundleEvent event) {
        this.modifiedBundle(bundle, event, bundle);
        return bundle;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Bundle object) {
        String activationPolicyHeader;
        if (bundle.getBundleId() == 0L && bundle.getState() == 16 && this.preemptiveShutdown) {
            try {
                this.stop(this.bundleContext);
            }
            catch (Exception e) {
                this.logger.error("Error while performing preemptive shutdown", (Throwable)e);
            }
            return;
        }
        if (bundle.getState() != 32 && bundle.getState() != 8) {
            if (bundle != this.bundleContext.getBundle()) {
                this.destroyExtension(bundle);
            }
            return;
        }
        if (this.stopping) {
            return;
        }
        if (!(bundle.getState() != 8 || (activationPolicyHeader = (String)bundle.getHeaders().get("Bundle-ActivationPolicy")) != null && activationPolicyHeader.startsWith("lazy"))) {
            return;
        }
        this.createExtension(bundle);
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Bundle object) {
        this.destroyExtension(bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createExtension(Bundle bundle) {
        try {
            BundleContext context = bundle.getBundleContext();
            if (context == null) {
                return;
            }
            final Extension extension = this.doCreateExtension(bundle);
            if (extension == null) {
                return;
            }
            ConcurrentMap<Bundle, Extension> concurrentMap = this.extensions;
            synchronized (concurrentMap) {
                if (this.extensions.putIfAbsent(bundle, extension) != null) {
                    return;
                }
            }
            if (this.synchronous) {
                this.logger.debug("Starting extension for bundle {} synchronously", (Object)bundle.getSymbolicName());
                extension.start();
            } else {
                this.logger.debug("Scheduling start of extension for bundle {} asynchronously", (Object)bundle.getSymbolicName());
                this.getExecutors().submit(new Runnable(){

                    @Override
                    public void run() {
                        extension.start();
                    }
                });
            }
        }
        catch (Throwable t) {
            this.logger.warn("Error while creating extension for bundle " + bundle, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyExtension(final Bundle bundle) {
        FutureTask<Object> future;
        ConcurrentMap<Bundle, Extension> concurrentMap = this.extensions;
        synchronized (concurrentMap) {
            this.logger.debug("Starting destruction process for bundle {}", (Object)bundle.getSymbolicName());
            future = (FutureTask<Object>)this.destroying.get(bundle);
            if (future == null) {
                final Extension extension = (Extension)this.extensions.remove(bundle);
                if (extension != null) {
                    this.logger.debug("Scheduling extension destruction for {}.", (Object)bundle.getSymbolicName());
                    future = new FutureTask<Object>(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            AbstractExtender.this.logger.info("Destroying extension for bundle {}", (Object)bundle.getSymbolicName());
                            try {
                                extension.destroy();
                            }
                            finally {
                                AbstractExtender.this.logger.debug("Finished destroying extension for bundle {}", (Object)bundle.getSymbolicName());
                                ConcurrentMap concurrentMap = AbstractExtender.this.extensions;
                                synchronized (concurrentMap) {
                                    AbstractExtender.this.destroying.remove(bundle);
                                }
                            }
                        }
                    }, null);
                    this.destroying.put(bundle, future);
                } else {
                    this.logger.debug("Not an extended bundle or destruction of extension already finished for {}.", (Object)bundle.getSymbolicName());
                }
            } else {
                this.logger.debug("Destruction already scheduled for {}.", (Object)bundle.getSymbolicName());
            }
        }
        if (future != null) {
            try {
                this.logger.debug("Waiting for extension destruction for {}.", (Object)bundle.getSymbolicName());
                future.run();
                future.get();
            }
            catch (Throwable t) {
                this.logger.warn("Error while destroying extension for bundle " + bundle, t);
            }
        }
    }

    protected abstract Extension doCreateExtension(Bundle var1) throws Exception;
}

