/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.xml;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.xml.AbstractCastorConfigDao;
import org.opennms.core.xml.CastorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWritableCastorConfigDao<K, V>
extends AbstractCastorConfigDao<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWritableCastorConfigDao.class);
    private final ReadWriteLock m_globalLock = new ReentrantReadWriteLock();
    private final Lock m_readLock = this.m_globalLock.readLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();

    public AbstractWritableCastorConfigDao(Class<K> entityClass, String description) {
        super(entityClass, description);
    }

    public Lock getReadLock() {
        return this.m_readLock;
    }

    public Lock getWriteLock() {
        return this.m_writeLock;
    }

    protected V getObject() {
        this.getReadLock().lock();
        try {
            Object object = this.getContainer().getObject();
            return (V)object;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public void saveCurrent() throws IOException, MarshalException, ValidationException {
        File file;
        try {
            file = this.getConfigResource().getFile();
        }
        catch (IOException e) {
            LOG.warn("Resource '{}' cannot be saved because it does not seem to have an underlying File object: {}", (Object)this.getConfigResource(), (Object)e);
            throw e;
        }
        this.getWriteLock().lock();
        try {
            CastorUtils.marshalViaString(this.getObject(), file);
        }
        finally {
            this.getWriteLock().unlock();
        }
        this.update();
    }

    public void update() throws IOException {
        this.getReadLock().lock();
        try {
            this.getContainer().reload();
        }
        finally {
            this.getReadLock().unlock();
        }
    }
}

