/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.nsclient;

import java.net.InetAddress;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.network.InetAddressXmlAdapter;

@XmlRootElement(name="nsclient-agent-config")
@XmlAccessorType(value=XmlAccessType.NONE)
public class NSClientAgentConfig {
    public static final int DEFAULT_TIMEOUT = 3000;
    public static final int DEFAULT_PORT = 1248;
    public static final int DEFAULT_RETRIES = 1;
    public static final String DEFAULT_PASSWORD = "None";
    @XmlAttribute(name="address")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    private InetAddress m_address;
    @XmlAttribute(name="timeout")
    private int m_timeout;
    @XmlAttribute(name="retries")
    private int m_retries;
    @XmlAttribute(name="port")
    private int m_port;
    @XmlAttribute(name="password")
    private String m_password;

    public NSClientAgentConfig() {
        this.setDefaults();
    }

    public NSClientAgentConfig(InetAddress agentAddress) {
        this.m_address = agentAddress;
        this.setDefaults();
    }

    private void setDefaults() {
        this.m_timeout = 3000;
        this.m_retries = 1;
        this.m_port = 1248;
        this.m_password = DEFAULT_PASSWORD;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("AgentConfig[");
        buff.append("Address: " + this.m_address);
        buff.append(", Port: " + this.m_port);
        buff.append(", Password: " + String.valueOf(this.m_password));
        buff.append(", Timeout: " + this.m_timeout);
        buff.append(", Retries: " + this.m_retries);
        buff.append("]");
        return buff.toString();
    }

    public InetAddress getAddress() {
        return this.m_address;
    }

    public void setAddress(InetAddress address) {
        this.m_address = address;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    public int getRetries() {
        return this.m_retries;
    }

    public void setRetries(int retries) {
        this.m_retries = retries;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getPassword() {
        return this.m_password;
    }

    public int hashCode() {
        return Objects.hash(this.m_address, this.m_timeout, this.m_retries, this.m_port, this.m_password);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NSClientAgentConfig)) {
            return false;
        }
        NSClientAgentConfig other = (NSClientAgentConfig)obj;
        return Objects.equals(this.m_address, other.m_address) && Objects.equals(this.m_timeout, other.m_timeout) && Objects.equals(this.m_retries, other.m_retries) && Objects.equals(this.m_port, other.m_port) && Objects.equals(this.m_password, other.m_password);
    }
}

