/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple;

import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.opennms.netmgt.provision.detector.simple.request.LineOrientedRequest;
import org.opennms.netmgt.provision.detector.simple.response.HttpStatusResponse;
import org.opennms.netmgt.provision.support.AsyncBasicDetectorMinaImpl;
import org.opennms.netmgt.provision.support.ResponseValidator;
import org.opennms.netmgt.provision.support.codec.HttpProtocolCodecFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpDetector
extends AsyncBasicDetectorMinaImpl<LineOrientedRequest, HttpStatusResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpDetector.class);
    private static final String DEFAULT_SERVICE_NAME = "HTTP";
    private static final int DEFAULT_PORT = 80;
    private static String DEFAULT_URL = "/";
    private static int DEFAULT_MAX_RET_CODE = 399;
    private String m_url;
    private int m_maxRetCode;
    private boolean m_checkRetCode = false;

    public HttpDetector() {
        super(DEFAULT_SERVICE_NAME, 80);
        this.contructDefaults();
    }

    public HttpDetector(String serviceName, int port) {
        super(serviceName, port);
        this.contructDefaults();
    }

    private void contructDefaults() {
        this.setProtocolCodecFilter(new ProtocolCodecFilter((ProtocolCodecFactory)new HttpProtocolCodecFactory()));
        this.setUrl(DEFAULT_URL);
        this.setMaxRetCode(DEFAULT_MAX_RET_CODE);
    }

    protected void onInit() {
        this.send(HttpDetector.request(this.httpCommand("GET")), HttpDetector.contains(DEFAULT_SERVICE_NAME, this.getUrl(), this.isCheckRetCode(), this.getMaxRetCode()));
    }

    protected String httpCommand(String command) {
        return String.format("%s %s HTTP/1.0\r\n\r\n", command, this.getUrl());
    }

    protected static LineOrientedRequest request(String command) {
        return new LineOrientedRequest(command);
    }

    protected static ResponseValidator<HttpStatusResponse> contains(final String pattern, final String url, final boolean isCheckCode, final int maxRetCode) {
        return new ResponseValidator<HttpStatusResponse>(){

            public boolean validate(HttpStatusResponse message) {
                try {
                    return message.validateResponse(pattern, url, isCheckCode, maxRetCode);
                }
                catch (Exception e) {
                    LOG.debug("Failed to validate response.", (Throwable)e);
                    return false;
                }
            }
        };
    }

    public void setUrl(String url) {
        this.m_url = url;
    }

    public String getUrl() {
        return this.m_url;
    }

    public void setMaxRetCode(int maxRetCode) {
        this.m_maxRetCode = maxRetCode;
    }

    public int getMaxRetCode() {
        return this.m_maxRetCode;
    }

    public void setCheckRetCode(boolean checkRetCode) {
        this.m_checkRetCode = checkRetCode;
    }

    public boolean isCheckRetCode() {
        return this.m_checkRetCode;
    }
}

