/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.jicmp.jna;

import com.sun.jna.LastErrorException;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.UnknownHostException;
import org.opennms.jicmp.jna.NativeDatagramPacket;
import org.opennms.jicmp.jna.UnsupportedPlatformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NativeDatagramSocket
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NativeDatagramSocket.class);
    public static final int AF_INET = 2;
    public static final int PF_INET = 2;
    public static final int AF_INET6;
    public static final int PF_INET6;
    public static final int SOCK_DGRAM;
    public static final int SOCK_RAW;
    public static final int IPPROTO_IP = 0;
    public static final int IPPROTO_IPV6 = 41;
    public static final int IPPROTO_ICMP = 1;
    public static final int IPPROTO_UDP = 17;
    public static final int IPPROTO_ICMPV6 = 58;
    public static final int IP_MTU_DISCOVER = 10;
    public static final int IPV6_DONTFRAG = 62;

    public NativeDatagramSocket() {
        if (AF_INET6 == -1) {
            throw new UnsupportedPlatformException(System.getProperty("os.name"));
        }
    }

    public static NativeDatagramSocket create(int family, int protocol, int listenPort) throws Exception {
        String implClassName = NativeDatagramSocket.getImplementationClassName(family);
        LOG.debug("{}({}, {}, {})", new Object[]{implClassName, family, protocol, listenPort});
        Class<NativeDatagramSocket> implementationClass = Class.forName(implClassName).asSubclass(NativeDatagramSocket.class);
        Constructor<NativeDatagramSocket> constructor = implementationClass.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        try {
            return constructor.newInstance(family, SOCK_DGRAM, protocol, listenPort);
        }
        catch (Exception e) {
            LOG.warn("Failed to create {} SOCK_DGRAM socket.  Trying with SOCK_RAW.", implementationClass, (Object)e);
            return constructor.newInstance(family, SOCK_RAW, protocol, listenPort);
        }
    }

    private static String getClassPackage() {
        return NativeDatagramSocket.class.getPackage().getName();
    }

    private static String getClassPrefix() {
        return Platform.isWindows() ? "Win32" : (Platform.isSolaris() ? "Sun" : (Platform.isMac() || Platform.isFreeBSD() || Platform.isOpenBSD() ? "BSD" : "Unix"));
    }

    private static String getFamilyPrefix(int family) {
        if (2 == family) {
            return "V4";
        }
        if (AF_INET6 == family) {
            return "V6";
        }
        throw new IllegalArgumentException("Unsupported Protocol Family: " + family);
    }

    private static String getImplementationClassName(int family) {
        return NativeDatagramSocket.getClassPackage() + "." + NativeDatagramSocket.getClassPrefix() + NativeDatagramSocket.getFamilyPrefix(family) + "NativeSocket";
    }

    public native String strerror(int var1);

    public native int setsockopt(int var1, int var2, int var3, Pointer var4, int var5);

    public void allowFragmentation(int level, int option_name, boolean frag) throws IOException {
        int socket = this.getSock();
        if (socket < 0) {
            throw new IOException("Invalid socket!");
        }
        IntByReference dontfragment = new IntByReference(frag ? 0 : 1);
        try {
            this.setsockopt(socket, level, option_name, dontfragment.getPointer(), Pointer.SIZE);
        }
        catch (LastErrorException e) {
            throw new IOException("setsockopt: " + this.strerror(e.getErrorCode()));
        }
    }

    public abstract int getSock();

    public abstract void allowFragmentation(boolean var1) throws IOException;

    public abstract void setTrafficClass(int var1) throws IOException;

    public abstract int receive(NativeDatagramPacket var1) throws UnknownHostException;

    public abstract int send(NativeDatagramPacket var1);

    @Override
    public abstract void close();

    static {
        PF_INET6 = AF_INET6 = Platform.isMac() ? 30 : (Platform.isLinux() ? 10 : (Platform.isWindows() ? 23 : (Platform.isFreeBSD() ? 28 : (Platform.isSolaris() ? 26 : -1))));
        SOCK_DGRAM = Platform.isSolaris() ? 1 : 2;
        SOCK_RAW = Platform.isSolaris() ? 4 : 3;
    }
}

