/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.NoOpConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;

public class MockConsumer<K, V>
implements Consumer<K, V> {
    private final Map<String, List<PartitionInfo>> partitions;
    private final SubscriptionState subscriptions;
    private Map<TopicPartition, List<ConsumerRecord<K, V>>> records;
    private Set<TopicPartition> paused;
    private boolean closed;
    private final Map<TopicPartition, Long> beginningOffsets;
    private final Map<TopicPartition, Long> endOffsets;
    private Queue<Runnable> pollTasks;
    private KafkaException exception;
    private AtomicBoolean wakeup;

    public MockConsumer(OffsetResetStrategy offsetResetStrategy) {
        this.subscriptions = new SubscriptionState(offsetResetStrategy);
        this.partitions = new HashMap<String, List<PartitionInfo>>();
        this.records = new HashMap<TopicPartition, List<ConsumerRecord<K, V>>>();
        this.paused = new HashSet<TopicPartition>();
        this.closed = false;
        this.beginningOffsets = new HashMap<TopicPartition, Long>();
        this.endOffsets = new HashMap<TopicPartition, Long>();
        this.pollTasks = new LinkedList<Runnable>();
        this.exception = null;
        this.wakeup = new AtomicBoolean(false);
    }

    @Override
    public Set<TopicPartition> assignment() {
        return this.subscriptions.assignedPartitions();
    }

    public void rebalance(Collection<TopicPartition> newAssignment) {
        this.records.clear();
        this.subscriptions.assignFromSubscribed(newAssignment);
    }

    @Override
    public Set<String> subscription() {
        return this.subscriptions.subscription();
    }

    @Override
    public void subscribe(Collection<String> topics) {
        this.subscribe(topics, (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
    }

    @Override
    public void subscribe(Pattern pattern, ConsumerRebalanceListener listener) {
        this.ensureNotClosed();
        this.subscriptions.subscribe(pattern, listener);
        HashSet<String> topicsToSubscribe = new HashSet<String>();
        for (String topic : this.partitions.keySet()) {
            if (!pattern.matcher(topic).matches() || this.subscriptions.subscription().contains(topic)) continue;
            topicsToSubscribe.add(topic);
        }
        this.ensureNotClosed();
        this.subscriptions.subscribeFromPattern(topicsToSubscribe);
    }

    @Override
    public void subscribe(Collection<String> topics, ConsumerRebalanceListener listener) {
        this.ensureNotClosed();
        this.subscriptions.subscribe(new HashSet<String>(topics), listener);
    }

    @Override
    public void assign(Collection<TopicPartition> partitions) {
        this.ensureNotClosed();
        this.subscriptions.assignFromUser(new HashSet<TopicPartition>(partitions));
    }

    @Override
    public void unsubscribe() {
        this.ensureNotClosed();
        this.subscriptions.unsubscribe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsumerRecords<K, V> poll(long timeout) {
        this.ensureNotClosed();
        Queue<Runnable> queue = this.pollTasks;
        synchronized (queue) {
            Runnable runnable = this.pollTasks.poll();
            if (runnable != null) {
                runnable.run();
            }
        }
        if (this.wakeup.get()) {
            this.wakeup.set(false);
            throw new WakeupException();
        }
        if (this.exception != null) {
            KafkaException exception = this.exception;
            this.exception = null;
            throw exception;
        }
        for (TopicPartition topicPartition : this.subscriptions.missingFetchPositions()) {
            this.updateFetchPosition(topicPartition);
        }
        for (Map.Entry entry : this.records.entrySet()) {
            List recs;
            if (this.subscriptions.isPaused((TopicPartition)entry.getKey()) || (recs = (List)entry.getValue()).isEmpty()) continue;
            this.subscriptions.position((TopicPartition)entry.getKey(), ((ConsumerRecord)recs.get(recs.size() - 1)).offset() + 1L);
        }
        ConsumerRecords<K, V> copy = new ConsumerRecords<K, V>(this.records);
        this.records = new HashMap<TopicPartition, List<ConsumerRecord<K, V>>>();
        return copy;
    }

    public void addRecord(ConsumerRecord<K, V> record) {
        this.ensureNotClosed();
        TopicPartition tp = new TopicPartition(record.topic(), record.partition());
        HashSet<TopicPartition> currentAssigned = new HashSet<TopicPartition>(this.subscriptions.assignedPartitions());
        if (!currentAssigned.contains(tp)) {
            throw new IllegalStateException("Cannot add records for a partition that is not assigned to the consumer");
        }
        List<ConsumerRecord<K, V>> recs = this.records.get(tp);
        if (recs == null) {
            recs = new ArrayList<ConsumerRecord<K, V>>();
            this.records.put(tp, recs);
        }
        recs.add(record);
    }

    public void setException(KafkaException exception) {
        this.exception = exception;
    }

    @Override
    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets, OffsetCommitCallback callback) {
        this.ensureNotClosed();
        for (Map.Entry<TopicPartition, OffsetAndMetadata> entry : offsets.entrySet()) {
            this.subscriptions.committed(entry.getKey(), entry.getValue());
        }
        if (callback != null) {
            callback.onComplete(offsets, null);
        }
    }

    @Override
    public void commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.commitAsync(offsets, null);
    }

    @Override
    public void commitAsync() {
        this.commitAsync(null);
    }

    @Override
    public void commitAsync(OffsetCommitCallback callback) {
        this.ensureNotClosed();
        this.commitAsync(this.subscriptions.allConsumed(), callback);
    }

    @Override
    public void commitSync() {
        this.commitSync(this.subscriptions.allConsumed());
    }

    @Override
    public void seek(TopicPartition partition, long offset) {
        this.ensureNotClosed();
        this.subscriptions.seek(partition, offset);
    }

    @Override
    public OffsetAndMetadata committed(TopicPartition partition) {
        this.ensureNotClosed();
        return this.subscriptions.committed(partition);
    }

    @Override
    public long position(TopicPartition partition) {
        this.ensureNotClosed();
        if (!this.subscriptions.isAssigned(partition)) {
            throw new IllegalArgumentException("You can only check the position for partitions assigned to this consumer.");
        }
        Long offset = this.subscriptions.position(partition);
        if (offset == null) {
            this.updateFetchPosition(partition);
            offset = this.subscriptions.position(partition);
        }
        return offset;
    }

    @Override
    public void seekToBeginning(Collection<TopicPartition> partitions) {
        this.ensureNotClosed();
        for (TopicPartition tp : partitions) {
            this.subscriptions.needOffsetReset(tp, OffsetResetStrategy.EARLIEST);
        }
    }

    public void updateBeginningOffsets(Map<TopicPartition, Long> newOffsets) {
        this.beginningOffsets.putAll(newOffsets);
    }

    @Override
    public void seekToEnd(Collection<TopicPartition> partitions) {
        this.ensureNotClosed();
        for (TopicPartition tp : partitions) {
            this.subscriptions.needOffsetReset(tp, OffsetResetStrategy.LATEST);
        }
    }

    public void updateEndOffsets(Map<TopicPartition, Long> newOffsets) {
        this.endOffsets.putAll(newOffsets);
    }

    @Override
    public Map<MetricName, ? extends Metric> metrics() {
        this.ensureNotClosed();
        return Collections.emptyMap();
    }

    @Override
    public List<PartitionInfo> partitionsFor(String topic) {
        this.ensureNotClosed();
        return this.partitions.get(topic);
    }

    @Override
    public Map<String, List<PartitionInfo>> listTopics() {
        this.ensureNotClosed();
        return this.partitions;
    }

    public void updatePartitions(String topic, List<PartitionInfo> partitions) {
        this.ensureNotClosed();
        this.partitions.put(topic, partitions);
    }

    @Override
    public void pause(Collection<TopicPartition> partitions) {
        for (TopicPartition partition : partitions) {
            this.subscriptions.pause(partition);
            this.paused.add(partition);
        }
    }

    @Override
    public void resume(Collection<TopicPartition> partitions) {
        for (TopicPartition partition : partitions) {
            this.subscriptions.resume(partition);
            this.paused.remove(partition);
        }
    }

    @Override
    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> partitions) {
        HashMap<TopicPartition, Long> result = new HashMap<TopicPartition, Long>();
        for (TopicPartition tp : partitions) {
            Long beginningOffset = this.beginningOffsets.get(tp);
            if (beginningOffset == null) {
                throw new IllegalStateException("The partition " + tp + " does not have a beginning offset.");
            }
            result.put(tp, beginningOffset);
        }
        return result;
    }

    @Override
    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> partitions) {
        HashMap<TopicPartition, Long> result = new HashMap<TopicPartition, Long>();
        for (TopicPartition tp : partitions) {
            Long endOffset = this.endOffsets.get(tp);
            if (endOffset == null) {
                throw new IllegalStateException("The partition " + tp + " does not have an end offset.");
            }
            result.put(tp, endOffset);
        }
        return result;
    }

    @Override
    public void close() {
        this.ensureNotClosed();
        this.closed = true;
    }

    public boolean closed() {
        return this.closed;
    }

    @Override
    public void wakeup() {
        this.wakeup.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedulePollTask(Runnable task) {
        Queue<Runnable> queue = this.pollTasks;
        synchronized (queue) {
            this.pollTasks.add(task);
        }
    }

    public void scheduleNopPollTask() {
        this.schedulePollTask(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    @Override
    public Set<TopicPartition> paused() {
        return Collections.unmodifiableSet(new HashSet<TopicPartition>(this.paused));
    }

    private void ensureNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("This consumer has already been closed.");
        }
    }

    private void updateFetchPosition(TopicPartition tp) {
        if (this.subscriptions.isOffsetResetNeeded(tp)) {
            this.resetOffsetPosition(tp);
        } else if (this.subscriptions.committed(tp) == null) {
            this.subscriptions.needOffsetReset(tp);
            this.resetOffsetPosition(tp);
        } else {
            this.subscriptions.seek(tp, this.subscriptions.committed(tp).offset());
        }
    }

    private void resetOffsetPosition(TopicPartition tp) {
        Long offset;
        OffsetResetStrategy strategy = this.subscriptions.resetStrategy(tp);
        if (strategy == OffsetResetStrategy.EARLIEST) {
            offset = this.beginningOffsets.get(tp);
            if (offset == null) {
                throw new IllegalStateException("MockConsumer didn't have beginning offset specified, but tried to seek to beginning");
            }
        } else if (strategy == OffsetResetStrategy.LATEST) {
            offset = this.endOffsets.get(tp);
            if (offset == null) {
                throw new IllegalStateException("MockConsumer didn't have end offset specified, but tried to seek to end");
            }
        } else {
            throw new NoOffsetForPartitionException(tp);
        }
        this.seek(tp, offset);
    }
}

