/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.datagram.client;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.opennms.netmgt.provision.support.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatagramClient
implements Client<DatagramPacket, DatagramPacket> {
    private static final Logger LOG = LoggerFactory.getLogger(DatagramClient.class);
    private DatagramSocket m_socket;

    public void close() {
        this.m_socket.close();
    }

    public void connect(InetAddress address, int port, int timeout) throws IOException {
        LOG.debug("Address: {}, port: {}, timeout: {}", new Object[]{address, port, timeout});
        this.m_socket = new DatagramSocket();
        this.m_socket.setSoTimeout(timeout);
        this.m_socket.connect(address, port);
    }

    public DatagramPacket receiveBanner() throws IOException {
        throw new UnsupportedOperationException("Client<DatagramPacket,DatagramPacket>.receiveBanner is not yet implemented");
    }

    public DatagramPacket sendRequest(DatagramPacket request) throws IOException {
        this.m_socket.send(request);
        byte[] data = new byte[512];
        DatagramPacket response = new DatagramPacket(data, data.length);
        this.m_socket.receive(response);
        return response;
    }
}

