/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.jmx;

import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import org.opennms.netmgt.config.jmx.MBeanServer;
import org.opennms.netmgt.dao.jmx.JmxConfigDao;
import org.opennms.netmgt.provision.DetectRequest;
import org.opennms.netmgt.provision.detector.jmx.JMXDetector;
import org.opennms.netmgt.provision.support.DetectRequestImpl;
import org.opennms.netmgt.provision.support.GenericServiceDetectorFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GenericJMXDetectorFactory<T extends JMXDetector>
extends GenericServiceDetectorFactory<JMXDetector> {
    @Autowired(required=false)
    protected JmxConfigDao jmxConfigDao;

    public GenericJMXDetectorFactory(Class<T> clazz) {
        super(clazz);
    }

    public T createDetector() {
        return (T)((Object)((JMXDetector)super.createDetector()));
    }

    public DetectRequest buildRequest(String location, InetAddress address, Integer port) {
        return new DetectRequestImpl(address, port, this.getRuntimeAttributes(location, address, port));
    }

    public Map<String, String> getRuntimeAttributes(String location, InetAddress address, Integer port) {
        String ipAddress = address.getHostAddress();
        if (port == null) {
            throw new IllegalArgumentException(" Port number needs to be specified in the form of port=number ");
        }
        if (this.jmxConfigDao == null) {
            return Collections.emptyMap();
        }
        MBeanServer serverConfig = this.jmxConfigDao.getConfig().lookupMBeanServer(ipAddress, port.intValue());
        if (serverConfig == null) {
            return Collections.emptyMap();
        }
        return serverConfig.getParameterMap();
    }

    public void setJmxConfigDao(JmxConfigDao jmxConfigDao) {
        this.jmxConfigDao = jmxConfigDao;
    }
}

