/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.persist.requisition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"m_categories"})
@XmlRootElement(name="monitored-service")
public class RequisitionMonitoredService
implements Comparable<RequisitionMonitoredService> {
    @XmlElement(name="category")
    protected List<RequisitionCategory> m_categories = new ArrayList<RequisitionCategory>();
    @XmlAttribute(name="service-name", required=true)
    protected String m_serviceName;

    public RequisitionMonitoredService() {
    }

    public RequisitionMonitoredService(String serviceName) {
        this.m_serviceName = serviceName;
    }

    @XmlTransient
    public int getCategoryCount() {
        return this.m_categories == null ? 0 : this.m_categories.size();
    }

    @XmlTransient
    public RequisitionCategory[] getCategory() {
        return this.m_categories.toArray(new RequisitionCategory[0]);
    }

    public List<RequisitionCategory> getCategories() {
        if (this.m_categories == null) {
            this.m_categories = new ArrayList<RequisitionCategory>();
        }
        return this.m_categories;
    }

    public void setCategories(List<RequisitionCategory> categories) {
        this.m_categories = categories;
    }

    public void deleteCategory(RequisitionCategory category) {
        if (this.m_categories != null) {
            Iterator<RequisitionCategory> i = this.m_categories.iterator();
            while (i.hasNext()) {
                RequisitionCategory cat = i.next();
                if (!cat.getName().equals(category.getName())) continue;
                i.remove();
                break;
            }
        }
    }

    public void deleteCategory(String category) {
        if (this.m_categories != null) {
            Iterator<RequisitionCategory> i = this.m_categories.iterator();
            while (i.hasNext()) {
                RequisitionCategory cat = i.next();
                if (!cat.getName().equals(category)) continue;
                i.remove();
                break;
            }
        }
    }

    public void insertCategory(RequisitionCategory category) {
        Iterator<RequisitionCategory> iterator = this.m_categories.iterator();
        while (iterator.hasNext()) {
            RequisitionCategory existing = iterator.next();
            if (!existing.getName().equals(category.getName())) continue;
            iterator.remove();
        }
        this.m_categories.add(0, category);
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public void setServiceName(String value) {
        this.m_serviceName = value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_categories == null ? 0 : this.m_categories.hashCode());
        result = 31 * result + (this.m_serviceName == null ? 0 : this.m_serviceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequisitionMonitoredService)) {
            return false;
        }
        RequisitionMonitoredService other = (RequisitionMonitoredService)obj;
        if (this.m_categories == null ? other.m_categories != null : !this.m_categories.equals(other.m_categories)) {
            return false;
        }
        return !(this.m_serviceName == null ? other.m_serviceName != null : !this.m_serviceName.equals(other.m_serviceName));
    }

    public String toString() {
        return "RequisitionMonitoredService [categories=" + this.m_categories + ", serviceName=" + this.m_serviceName + "]";
    }

    @Override
    public int compareTo(RequisitionMonitoredService other) {
        return new CompareToBuilder().append((Object)this.m_serviceName, (Object)other.m_serviceName).append(this.m_categories, other.m_categories).toComparison();
    }
}

