/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.amqp;

import java.nio.ByteBuffer;
import java.util.Collection;

public final class Binary {
    private final byte[] _data;
    private final int _offset;
    private final int _length;
    private int _hashCode;

    public Binary(byte[] data) {
        this(data, 0, data.length);
    }

    public Binary(byte[] data, int offset, int length) {
        this._data = data;
        this._offset = offset;
        this._length = length;
    }

    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this._data, this._offset, this._length);
    }

    public final int hashCode() {
        int hc = this._hashCode;
        if (hc == 0) {
            for (int i = 0; i < this._length; ++i) {
                hc = 31 * hc + (0xFF & this._data[this._offset + i]);
            }
            this._hashCode = hc;
        }
        return hc;
    }

    public final boolean equals(Object o) {
        Binary buf = (Binary)o;
        if (o == null) {
            return false;
        }
        int size2 = this._length;
        if (size2 != buf._length) {
            return false;
        }
        byte[] myData = this._data;
        byte[] theirData = buf._data;
        int myOffset = this._offset;
        int theirOffset = buf._offset;
        int myLimit = myOffset + size2;
        while (myOffset < myLimit) {
            if (myData[myOffset++] == theirData[theirOffset++]) continue;
            return false;
        }
        return true;
    }

    public int getArrayOffset() {
        return this._offset;
    }

    public byte[] getArray() {
        return this._data;
    }

    public int getLength() {
        return this._length;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this._length; ++i) {
            byte c = this._data[this._offset + i];
            if (c > 31 && c < 127 && c != 92) {
                str.append((char)c);
                continue;
            }
            str.append(String.format("\\x%02x", c));
        }
        return str.toString();
    }

    public static Binary combine(Collection<Binary> binaries) {
        if (binaries.size() == 1) {
            return binaries.iterator().next();
        }
        int size2 = 0;
        for (Binary binary : binaries) {
            size2 += binary.getLength();
        }
        byte[] data = new byte[size2];
        int offset = 0;
        for (Binary binary : binaries) {
            System.arraycopy(binary._data, binary._offset, data, offset, binary._length);
            offset += binary._length;
        }
        return new Binary(data);
    }

    public Binary subBinary(int offset, int length) {
        return new Binary(this._data, this._offset + offset, length);
    }

    public static Binary create(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (buffer.isDirect() || buffer.isReadOnly()) {
            byte[] data = new byte[buffer.remaining()];
            ByteBuffer dup = buffer.duplicate();
            dup.get(data);
            return new Binary(data);
        }
        return new Binary(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
    }
}

