/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.support.builder;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.netmgt.collection.adapters.NodeLevelResourceAdapter;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.support.builder.Resource;

@XmlJavaTypeAdapter(value=NodeLevelResourceAdapter.class)
public class NodeLevelResource
implements Resource {
    private final int m_nodeId;

    public NodeLevelResource(int nodeId) {
        this.m_nodeId = nodeId;
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    @Override
    public Resource getParent() {
        return null;
    }

    @Override
    public String getInstance() {
        return String.valueOf(this.m_nodeId);
    }

    @Override
    public Path getPath(CollectionResource resource) {
        return Paths.get("", new String[0]);
    }

    public String toString() {
        return String.format("NodeLevelResource[nodeId=%d]", this.m_nodeId);
    }

    public int hashCode() {
        return Objects.hash(this.m_nodeId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeLevelResource)) {
            return false;
        }
        NodeLevelResource other = (NodeLevelResource)obj;
        return Objects.equals(this.m_nodeId, other.m_nodeId);
    }
}

