/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.dto;

import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.collection.dto.NodeLevelResourceDTO;
import org.opennms.netmgt.collection.support.builder.InterfaceLevelResource;

@XmlRootElement(name="interface-level-resource")
@XmlAccessorType(value=XmlAccessType.NONE)
public class InterfaceLevelResourceDTO {
    @XmlElement(name="node-level-resource")
    private NodeLevelResourceDTO parent;
    @XmlAttribute(name="if-name")
    private String ifName;

    public InterfaceLevelResourceDTO() {
    }

    public InterfaceLevelResourceDTO(InterfaceLevelResource resource) {
        this.parent = new NodeLevelResourceDTO(resource.getParent());
        this.ifName = resource.getIfName();
    }

    public String toString() {
        return String.format("InterfaceLevelResourceDTO[parent=%s, ifName=%s]", this.ifName);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.ifName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InterfaceLevelResourceDTO)) {
            return false;
        }
        InterfaceLevelResourceDTO other = (InterfaceLevelResourceDTO)obj;
        return Objects.equals(this.parent, other.parent) && Objects.equals(this.ifName, other.ifName);
    }

    public InterfaceLevelResource toResource() {
        return new InterfaceLevelResource(this.parent.toResource(), this.ifName);
    }
}

