/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.dto;

import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.collection.adapters.ResourceTypeMapper;
import org.opennms.netmgt.collection.api.ResourceType;
import org.opennms.netmgt.collection.dto.NodeLevelResourceDTO;
import org.opennms.netmgt.collection.support.builder.GenericTypeResource;

@XmlRootElement(name="generic-type-resource")
@XmlAccessorType(value=XmlAccessType.NONE)
public class GenericTypeResourceDTO {
    @XmlElement(name="node-level-resource")
    private NodeLevelResourceDTO parent;
    @XmlAttribute(name="name")
    private String name;
    @XmlAttribute(name="instance")
    private String instance;

    public GenericTypeResourceDTO() {
    }

    public GenericTypeResourceDTO(GenericTypeResource resource) {
        this.parent = new NodeLevelResourceDTO(resource.getParent());
        this.name = resource.getResourceType().getName();
        this.instance = resource.getInstance();
    }

    public String toString() {
        return String.format("GenericTypeResourceDTO[parent=%s, name=%s, instance=%s]", this.parent, this.name, this.instance);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.name, this.instance);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenericTypeResourceDTO)) {
            return false;
        }
        GenericTypeResourceDTO other = (GenericTypeResourceDTO)obj;
        return Objects.equals(this.parent, other.parent) && Objects.equals(this.name, other.name) && Objects.equals(this.instance, other.instance);
    }

    public GenericTypeResource toResource() {
        ResourceType resourceType = ResourceTypeMapper.getInstance().getResourceType(this.name);
        return new GenericTypeResource(this.parent.toResource(), resourceType, this.instance);
    }
}

