/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.dto;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.dto.CollectionAgentDTO;
import org.opennms.netmgt.collection.dto.CollectionResourceDTO;
import org.opennms.netmgt.collection.support.AbstractCollectionAttribute;
import org.opennms.netmgt.collection.support.AbstractCollectionAttributeType;
import org.opennms.netmgt.collection.support.AbstractCollectionResource;
import org.opennms.netmgt.collection.support.builder.Attribute;
import org.opennms.netmgt.collection.support.builder.CollectionStatus;
import org.opennms.netmgt.collection.support.builder.Resource;

@XmlRootElement(name="collection-set")
@XmlAccessorType(value=XmlAccessType.NONE)
public class CollectionSetDTO
implements CollectionSet {
    @XmlElement(name="agent")
    private CollectionAgentDTO agent;
    @XmlAttribute(name="status")
    private CollectionStatus status;
    @XmlAttribute(name="timestamp")
    private Date timestamp;
    @XmlElement(name="collection-resource")
    private List<CollectionResourceDTO> collectionResources;

    public CollectionSetDTO() {
    }

    public CollectionSetDTO(CollectionAgent agent, CollectionStatus status, Date timestamp, Map<Resource, List<Attribute<?>>> attributesByResource) {
        this.agent = new CollectionAgentDTO(agent);
        this.status = status;
        this.timestamp = timestamp;
        this.collectionResources = new ArrayList<CollectionResourceDTO>();
        for (Map.Entry<Resource, List<Attribute<?>>> entry : attributesByResource.entrySet()) {
            this.collectionResources.add(new CollectionResourceDTO(entry.getKey(), entry.getValue()));
        }
    }

    public String toString() {
        return String.format("CollectionSetDTO[agent=%s, collectionResources=%s, status=%s, timestamp=%s]", new Object[]{this.agent, this.collectionResources, this.status, this.timestamp});
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.agent, this.collectionResources, this.status, this.timestamp});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollectionSetDTO)) {
            return false;
        }
        CollectionSetDTO other = (CollectionSetDTO)obj;
        return Objects.equals(this.agent, other.agent) && Objects.equals(this.collectionResources, other.collectionResources) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.timestamp, other.timestamp);
    }

    @Override
    public int getStatus() {
        return this.status.getCode();
    }

    @Override
    public boolean ignorePersist() {
        return false;
    }

    @Override
    public Date getCollectionTimestamp() {
        return this.timestamp;
    }

    private Set<CollectionResource> buildCollectionResources() {
        LinkedHashSet<CollectionResource> collectionResources = new LinkedHashSet<CollectionResource>();
        for (CollectionResourceDTO entry : this.collectionResources) {
            final Resource resource = entry.getResource();
            AbstractCollectionResource collectionResource = new AbstractCollectionResource(this.agent){

                @Override
                public String getResourceTypeName() {
                    return "*";
                }

                @Override
                public String getInstance() {
                    return resource.getInstance();
                }

                @Override
                public Path getPath() {
                    return super.getPath().resolve(resource.getPath(this));
                }

                public String toString() {
                    return String.format("Resource[%s]/Node[%d]", resource, this.m_agent.getNodeId());
                }
            };
            for (final Attribute<?> attribute : entry.getAttributes()) {
                AttributeGroupType groupType = new AttributeGroupType(attribute.getGroup(), "all");
                AbstractCollectionAttributeType attributeType = new AbstractCollectionAttributeType(groupType){

                    @Override
                    public AttributeType getType() {
                        return attribute.getType();
                    }

                    @Override
                    public String getName() {
                        return attribute.getName();
                    }

                    @Override
                    public void storeAttribute(CollectionAttribute collectionAttribute, Persister persister) {
                        if (AttributeType.STRING.equals((Object)attribute.getType())) {
                            persister.persistStringAttribute(collectionAttribute);
                        } else {
                            persister.persistNumericAttribute(collectionAttribute);
                        }
                    }

                    public String toString() {
                        return String.format("AttributeType[%s]/type[%s]", new Object[]{this.getName(), this.getType()});
                    }
                };
                collectionResource.addAttribute(new AbstractCollectionAttribute(attributeType, collectionResource){

                    @Override
                    public String getMetricIdentifier() {
                        return attribute.getName();
                    }

                    @Override
                    public Number getNumericValue() {
                        return attribute.getNumericValue();
                    }

                    @Override
                    public String getStringValue() {
                        return attribute.getStringValue();
                    }

                    public String toString() {
                        return String.format("Attribute[%s:%s]", this.getMetricIdentifier(), attribute.getValue());
                    }
                });
            }
            collectionResources.add(collectionResource);
        }
        return collectionResources;
    }

    @Override
    public void visit(CollectionSetVisitor visitor) {
        visitor.visitCollectionSet(this);
        for (CollectionResource resource : this.buildCollectionResources()) {
            resource.visit(visitor);
        }
        visitor.completeCollectionSet(this);
    }
}

