/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collection.dto;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.network.InetAddressXmlAdapter;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.dto.CollectionAttributeDTO;
import org.opennms.netmgt.snmp.InetAddrUtils;

@XmlRootElement(name="agent")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CollectionAgentDTO
implements CollectionAgent {
    @XmlAttribute(name="type")
    private int type;
    @XmlElement(name="attribute")
    private List<CollectionAttributeDTO> attributes = new ArrayList<CollectionAttributeDTO>();
    @XmlAttribute(name="address")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    private InetAddress address;
    @XmlAttribute(name="store-by-fs")
    private Boolean storeByForeignSource;
    @XmlAttribute(name="node-id")
    private int nodeId;
    @XmlAttribute(name="node-label")
    private String nodeLabel;
    @XmlAttribute(name="foreign-source")
    private String foreignSource;
    @XmlAttribute(name="foreign-id")
    private String foreignId;
    @XmlAttribute(name="location")
    private String location;
    @XmlAttribute(name="storage-dir")
    private String storageDir;
    @XmlAttribute(name="sys-object-id")
    private String sysObjectId;
    @XmlAttribute(name="sys-up-time")
    private long sysUpTime;

    public CollectionAgentDTO() {
    }

    public CollectionAgentDTO(CollectionAgent agent) {
        Objects.requireNonNull(agent);
        for (String attribute : agent.getAttributeNames()) {
            this.setAttribute(attribute, agent.getAttribute(attribute));
        }
        this.type = agent.getType();
        this.address = (InetAddress)agent.getAddress();
        this.storeByForeignSource = agent.isStoreByForeignSource();
        this.nodeId = agent.getNodeId();
        this.nodeLabel = agent.getNodeLabel();
        this.foreignSource = agent.getForeignSource();
        this.foreignId = agent.getForeignId();
        this.location = agent.getLocationName();
        this.setStorageDir(agent.getStorageDir());
        this.sysObjectId = agent.getSysObjectId();
        this.sysUpTime = agent.getSavedSysUpTime();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public Set<String> getAttributeNames() {
        return this.attributes.stream().map(a -> a.getKey()).collect(Collectors.toSet());
    }

    public <V> V getAttribute(String property) {
        for (CollectionAttributeDTO attribute : this.attributes) {
            if (!attribute.getKey().equals(property)) continue;
            return (V)attribute.getValueOrContents();
        }
        return null;
    }

    public Object setAttribute(String property, Object value) {
        for (CollectionAttributeDTO attribute : this.attributes) {
            if (!attribute.getKey().equals(property)) continue;
            Object previousValue = attribute.getValueOrContents();
            attribute.setValueOrContents(value);
            return previousValue;
        }
        this.attributes.add(new CollectionAttributeDTO(property, value));
        return null;
    }

    @Override
    public Boolean isStoreByForeignSource() {
        return this.storeByForeignSource;
    }

    public void setStoreByForeignSource(Boolean storeByForeignSource) {
        this.storeByForeignSource = storeByForeignSource;
    }

    @Override
    public String getHostAddress() {
        return this.address != null ? InetAddrUtils.str((InetAddress)this.address) : null;
    }

    @Override
    public void setSavedIfCount(int ifCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(int nodeId) {
        this.nodeId = nodeId;
    }

    @Override
    public String getNodeLabel() {
        return this.nodeLabel;
    }

    public void setNodeLabel(String nodeLabel) {
        this.nodeLabel = nodeLabel;
    }

    @Override
    public String getForeignSource() {
        return this.foreignSource;
    }

    public void setForeignSource(String foreignSource) {
        this.foreignSource = foreignSource;
    }

    @Override
    public String getForeignId() {
        return this.foreignId;
    }

    public void setForeignId(String foreignId) {
        this.foreignId = foreignId;
    }

    @Override
    public String getLocationName() {
        return this.location;
    }

    public void setLocationName(String location) {
        this.location = location;
    }

    @Override
    public File getStorageDir() {
        return this.storageDir != null ? new File(this.storageDir) : null;
    }

    public void setStorageDir(File storageDir) {
        this.storageDir = storageDir != null ? storageDir.getPath() : null;
    }

    @Override
    public String getSysObjectId() {
        return this.sysObjectId;
    }

    public void setSysObjectId(String sysObjectId) {
        this.sysObjectId = sysObjectId;
    }

    @Override
    public long getSavedSysUpTime() {
        return this.sysUpTime;
    }

    @Override
    public void setSavedSysUpTime(long sysUpTime) {
        this.sysUpTime = sysUpTime;
    }

    @Override
    public String toString() {
        return String.format("CollectionAgentDTO[type=%d, attributes=%s, address=%s, storeByForeignSource=%s, nodeId=%d, nodeLabel=%s, foreignSource=%s, foreignId=%s, location=%s, storageDir=%s, sysObjectId=%s, sysUpTime=%d]", this.type, this.attributes, this.address != null ? InetAddrUtils.str((InetAddress)this.address) : null, this.storeByForeignSource, this.nodeId, this.nodeLabel, this.foreignSource, this.foreignId, this.location, this.storageDir, this.sysObjectId, this.sysUpTime);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.attributes, this.address, this.storeByForeignSource, this.nodeId, this.nodeLabel, this.foreignSource, this.foreignId, this.location, this.storageDir, this.sysObjectId, this.sysUpTime);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollectionAgentDTO)) {
            return false;
        }
        CollectionAgentDTO other = (CollectionAgentDTO)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.address, other.address) && Objects.equals(this.storeByForeignSource, other.storeByForeignSource) && Objects.equals(this.nodeId, other.nodeId) && Objects.equals(this.nodeLabel, other.nodeLabel) && Objects.equals(this.foreignSource, other.foreignSource) && Objects.equals(this.foreignId, other.foreignId) && Objects.equals(this.location, other.location) && Objects.equals(this.storageDir, other.storageDir) && Objects.equals(this.sysObjectId, other.sysObjectId) && Objects.equals(this.sysUpTime, other.sysUpTime);
    }
}

