/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.client.ArrayEnumeration;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Enumeration;

public class LDAPUrl
implements Cloneable,
Externalizable {
    private static final int DEFAULT_SCOPE = 0;
    private boolean secure = false;
    private boolean ipV6 = false;
    private String host = null;
    private int port = 0;
    private String dn = null;
    private String[] attrs = null;
    private String filter = null;
    private int scope = 0;
    private String[] extensions = null;

    public LDAPUrl() {
    }

    public LDAPUrl(String string) throws MalformedURLException {
        this.parseURL(string);
    }

    public LDAPUrl(String string, int n, String string2) {
        this.host = string;
        this.port = n;
        this.dn = string2;
    }

    public LDAPUrl(String string, int n, String string2, String[] stringArray, int n2, String string3, String[] stringArray2) {
        this.host = string;
        this.port = n;
        this.dn = string2;
        this.attrs = (String[])stringArray.clone();
        this.scope = n2;
        this.filter = string3;
        this.extensions = (String[])stringArray2.clone();
    }

    public LDAPUrl(String string, int n, String string2, String[] stringArray, int n2, String string3, String[] stringArray2, boolean bl) {
        this.host = string;
        this.port = n;
        this.dn = string2;
        this.attrs = stringArray;
        this.scope = n2;
        this.filter = string3;
        this.extensions = (String[])stringArray2.clone();
        this.secure = bl;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
    }

    public static String decode(String string) throws MalformedURLException {
        int n = 0;
        int n2 = string.indexOf("%", n);
        if (n2 < 0) {
            return string;
        }
        int n3 = 0;
        int n4 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n4);
        while (true) {
            if (n2 > n4 - 3) {
                throw new MalformedURLException("LDAPUrl.decode: must be two hex characters following escape character '%'");
            }
            if (n2 < 0) {
                n2 = n4;
            }
            stringBuffer.append(string.substring(n3, n2));
            if (++n2 >= n4) break;
            n3 = n2 + 2;
            try {
                stringBuffer.append((char)Integer.parseInt(string.substring(n2, n3), 16));
            }
            catch (NumberFormatException numberFormatException) {
                throw new MalformedURLException("LDAPUrl.decode: error converting hex characters to integer \"" + numberFormatException.getMessage() + "\"");
            }
            n = n3;
            if (n == n4) break;
            n2 = string.indexOf("%", n);
        }
        return stringBuffer.toString();
    }

    public static String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= '\u001f' || c == '\u007f' || c >= '\u0080' && c <= '\u00ff' || c == '<' || c == '>' || c == '\"' || c == '#' || c == '%' || c == '{' || c == '}' || c == '|' || c == '\\' || c == '^' || c == '~' || c == '[' || c == '\'' || c == ' ' || c == ';' || c == '/' || c == '?' || c == ':' || c == '@' || c == '=' || c == '&') {
                String string2 = Integer.toHexString(c);
                if (string2.length() == 1) {
                    stringBuffer.append("%0" + string2);
                    continue;
                }
                stringBuffer.append("%" + Integer.toHexString(c));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String[] getAttributeArray() {
        return this.attrs;
    }

    public Enumeration getAttributes() {
        return new ArrayEnumeration(this.attrs);
    }

    public String getDN() {
        return this.dn;
    }

    void setDN(String string) {
        this.dn = string;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        if (this.port == 0) {
            return 389;
        }
        return this.port;
    }

    public int getScope() {
        return this.scope;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(256);
        if (this.secure) {
            stringBuffer.append("ldaps://");
        } else {
            stringBuffer.append("ldap://");
        }
        if (this.ipV6) {
            stringBuffer.append("[" + this.host + "]");
        } else {
            stringBuffer.append(this.host);
        }
        if (this.port != 0) {
            stringBuffer.append(":" + this.port);
        }
        if (this.dn == null && this.attrs == null && this.scope == 0 && this.filter == null && this.extensions == null) {
            return stringBuffer.toString();
        }
        stringBuffer.append("/");
        if (this.dn != null) {
            stringBuffer.append(this.dn);
        }
        if (this.attrs == null && this.scope == 0 && this.filter == null && this.extensions == null) {
            return stringBuffer.toString();
        }
        stringBuffer.append("?");
        if (this.attrs != null) {
            for (n = 0; n < this.attrs.length; ++n) {
                stringBuffer.append(this.attrs[n]);
                if (n >= this.attrs.length - 1) continue;
                stringBuffer.append(",");
            }
        }
        if (this.scope == 0 && this.filter == null && this.extensions == null) {
            return stringBuffer.toString();
        }
        stringBuffer.append("?");
        if (this.scope != 0) {
            if (this.scope == 1) {
                stringBuffer.append("one");
            } else {
                stringBuffer.append("sub");
            }
        }
        if (this.filter == null && this.extensions == null) {
            return stringBuffer.toString();
        }
        if (this.filter == null) {
            stringBuffer.append("?");
        } else {
            stringBuffer.append("?" + this.getFilter());
        }
        if (this.extensions == null) {
            return stringBuffer.toString();
        }
        stringBuffer.append("?");
        if (this.extensions != null) {
            for (n = 0; n < this.extensions.length; ++n) {
                stringBuffer.append(this.extensions[n]);
                if (n >= this.extensions.length - 1) continue;
                stringBuffer.append(",");
            }
        }
        return stringBuffer.toString();
    }

    private String[] parseList(String string, char c, int n, int n2) {
        int n3;
        if (n2 - n < 1) {
            return null;
        }
        int n4 = n;
        int n5 = 0;
        while (n4 > 0) {
            ++n5;
            n3 = string.indexOf(c, n4);
            if (n3 <= 0 || n3 >= n2) break;
            n4 = n3 + 1;
        }
        n4 = n;
        String[] stringArray = new String[n5];
        n5 = 0;
        while (n4 > 0) {
            n3 = string.indexOf(c, n4);
            if (n4 > n2) break;
            if (n3 < 0) {
                n3 = n2;
            }
            if (n3 > n2) {
                n3 = n2;
            }
            stringArray[n5] = string.substring(n4, n3);
            n4 = n3 + 1;
            ++n5;
        }
        return stringArray;
    }

    private void parseURL(String string) throws MalformedURLException {
        int n = 0;
        int n2 = string.length();
        if (string == null) {
            throw new MalformedURLException("LDAPUrl: URL cannot be null");
        }
        if (string.charAt(n) == '<') {
            if (string.charAt(n2 - 1) != '>') {
                throw new MalformedURLException("LDAPUrl: URL bad enclosure");
            }
            ++n;
            --n2;
        }
        if (string.substring(n, n + 4).equalsIgnoreCase("URL:")) {
            n += 4;
        }
        if (string.substring(n, n + 7).equalsIgnoreCase("ldap://")) {
            n += 7;
            this.port = 389;
        } else if (string.substring(n, n + 8).equalsIgnoreCase("ldaps://")) {
            this.secure = true;
            n += 8;
            this.port = 636;
        } else {
            throw new MalformedURLException("LDAPUrl: URL scheme is not ldap");
        }
        int n3 = string.indexOf("/", n);
        int n4 = n2;
        boolean bl = false;
        if (n3 < 0) {
            n3 = string.indexOf("?", n);
            if (n3 > 0) {
                if (string.charAt(n3 + 1) == '?') {
                    n4 = n3++;
                    bl = true;
                } else {
                    n3 = -1;
                }
            }
        } else {
            n4 = n3;
        }
        int n5 = n4;
        if (string.charAt(n) == '[') {
            n5 = string.indexOf(93, n + 1);
            if (n5 >= n4 || n5 == -1) {
                throw new MalformedURLException("LDAPUrl: \"]\" is missing on IPV6 host name");
            }
            this.host = string.substring(n + 1, n5);
            int n6 = string.indexOf(":", n5);
            if (n6 < n4 && n6 != -1) {
                this.port = Integer.decode(string.substring(n6 + 1, n4));
            }
        } else {
            int n7 = string.indexOf(":", n);
            if (n7 < 0 || n7 > n4) {
                this.host = string.substring(n, n4);
            } else {
                this.host = string.substring(n, n7);
                this.port = Integer.decode(string.substring(n7 + 1, n4));
            }
        }
        if ((n = n4 + 1) >= n2 || n3 < 0) {
            return;
        }
        n = n3 + 1;
        int n8 = string.indexOf(63, n);
        this.dn = n8 < 0 ? string.substring(n, n2) : string.substring(n, n8);
        n = n8 + 1;
        if (n >= n2 || n8 < 0 || bl) {
            return;
        }
        int n9 = string.indexOf(63, n);
        if (n9 < 0) {
            n9 = n2;
        }
        this.attrs = this.parseList(string, ',', n8 + 1, n9);
        n = n9 + 1;
        if (n >= n2) {
            return;
        }
        int n10 = string.indexOf(63, n);
        String string2 = n10 < 0 ? string.substring(n, n2) : string.substring(n, n10);
        if (string2.equalsIgnoreCase("")) {
            this.scope = 0;
        } else if (string2.equalsIgnoreCase("base")) {
            this.scope = 0;
        } else if (string2.equalsIgnoreCase("one")) {
            this.scope = 1;
        } else if (string2.equalsIgnoreCase("sub")) {
            this.scope = 2;
        } else if (string2.equalsIgnoreCase("subordinateSubtree")) {
            this.scope = 4;
        } else {
            throw new MalformedURLException("LDAPUrl: URL invalid scope");
        }
        n = n10 + 1;
        if (n >= n2 || n10 < 0) {
            return;
        }
        n = n10 + 1;
        int n11 = string.indexOf(63, n);
        String string3 = n11 < 0 ? string.substring(n, n2) : string.substring(n, n11);
        if (!string3.equals("")) {
            this.filter = string3;
        }
        if ((n = n11 + 1) >= n2 || n11 < 0) {
            return;
        }
        int n12 = string.indexOf(63, n);
        if (n12 > 0) {
            throw new MalformedURLException("LDAPUrl: URL has too many ? fields");
        }
        this.extensions = this.parseList(string, ',', n, n2);
    }

    public void writeDSML(OutputStream outputStream) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        outputStreamWriter.write("<LDAPUrl>" + this.toString() + "</LDAPUrl>");
        ((Writer)outputStreamWriter).close();
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        SAXEventMultiplexer sAXEventMultiplexer = new SAXEventMultiplexer();
        sAXEventMultiplexer.setLDAPXMLHandler(LDAPUrl.getXMLHandler("LDAPUrl", null));
        return (LDAPUrl)sAXEventMultiplexer.parseXML(inputStream);
    }

    static LDAPXMLHandler getXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){

            protected void endElement() {
                try {
                    LDAPUrl lDAPUrl = new LDAPUrl(this.getValue());
                    this.setObject(lDAPUrl);
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
        };
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append(ValueXMLhandler.newLine(0));
        String string = "";
        string = string + "*************************************************************************\n";
        string = string + "** The encrypted data above and below is the Class definition and  ******\n";
        string = string + "** other data specific to Java Serialization Protocol. The data  ********\n";
        string = string + "** which is of most application specific interest is as follows... ******\n";
        string = string + "*************************************************************************\n";
        string = string + "****************** Start of application data ****************************\n";
        string = string + "*************************************************************************\n";
        stringBuffer.append(string);
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append("<LDAPUrl>");
        stringBuffer.append(this.toString());
        stringBuffer.append("</LDAPUrl>");
        stringBuffer.append(ValueXMLhandler.newLine(0));
        stringBuffer.append(ValueXMLhandler.newLine(0));
        String string2 = "";
        string2 = string2 + "*************************************************************************\n";
        string2 = string2 + "****************** End of application data ******************************\n";
        string2 = string2 + "*************************************************************************\n";
        stringBuffer.append(string2);
        stringBuffer.append(ValueXMLhandler.newLine(0));
        objectOutput.writeUTF(stringBuffer.toString());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = objectInput.readUTF();
        String string2 = string.substring(string.indexOf(60), string.lastIndexOf(62) + 1);
        StringBuffer stringBuffer = new StringBuffer();
        ValueXMLhandler.parseInput(string2, stringBuffer);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(stringBuffer.toString().getBytes()));
        LDAPUrl lDAPUrl = (LDAPUrl)LDAPUrl.readDSML(bufferedInputStream);
        this.parseURL(lDAPUrl.toString());
        lDAPUrl = null;
    }
}

