/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.exolab.castor.types.DateTimeBase;
import org.exolab.castor.types.OperationNotSupportedException;

public class Time
extends DateTimeBase {
    private static final long serialVersionUID = -8268707778437931489L;
    private static final String TIME_FORMAT_MILLI = "HH:mm:ss.SSS";
    private static final String TIME_FORMAT_NO_MILLI = "HH:mm:ss";
    private static final String BAD_TIME = "Bad Time format: ";

    public Time() {
    }

    public Time(short[] values) {
        this.setValues(values);
    }

    public Time(long l) {
        if (l > 86400000L) {
            throw new IllegalArgumentException("Bad Time: the long value can't represent more than 24h.");
        }
        this.setHour((short)(l / 3600000L));
        this.setMinute((short)((l %= 3600000L) / 60000L));
        this.setSecond((short)((l %= 60000L) / 1000L), (short)(l % 1000L));
    }

    public Time(String time) throws ParseException {
        Time.parseTimeInternal(time, this);
    }

    public void setValues(short[] values) {
        if (values.length != 4) {
            throw new IllegalArgumentException("Time#setValues: not the right number of values");
        }
        this.setHour(values[0]);
        this.setMinute(values[1]);
        this.setSecond(values[2], values[3]);
    }

    public short[] getValues() {
        short[] result = new short[]{this.getHour(), this.getMinute(), this.getSeconds(), this.getMilli()};
        return result;
    }

    public Date toDate() {
        Date date = null;
        SimpleDateFormat df = null;
        String temp = this.toString();
        df = temp.indexOf(46) > 0 ? new SimpleDateFormat(TIME_FORMAT_MILLI) : new SimpleDateFormat(TIME_FORMAT_NO_MILLI);
        this.setDateFormatTimeZone(df);
        try {
            date = df.parse(temp);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        return date;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        this.appendTimeString(result);
        this.appendTimeZoneString(result);
        return result.toString();
    }

    public static Object parse(String str) throws ParseException {
        return Time.parseTime(str);
    }

    public static Time parseTime(String str) throws ParseException {
        return Time.parseTimeInternal(str, null);
    }

    private static Time parseTimeInternal(String str, Time result) throws ParseException {
        if (str == null) {
            throw new IllegalArgumentException("The string to be parsed must not be null.");
        }
        if (result == null) {
            result = new Time();
        }
        char[] chars = str.toCharArray();
        int idx = Time.parseTime(str, result, chars, 0, BAD_TIME);
        Time.parseTimeZone(str, result, chars, idx, BAD_TIME);
        return result;
    }

    public boolean hasIsNegative() {
        return false;
    }

    public boolean isNegative() {
        String err = "org.exolab.castor.types.Time does not have a 'negative' field.";
        throw new OperationNotSupportedException(err);
    }

    public void setNegative() {
        String err = "org.exolab.castor.types.Time cannot be negative.";
        throw new OperationNotSupportedException(err);
    }

    public boolean hasCentury() {
        return false;
    }

    public short getCentury() {
        String err = "org.exolab.castor.types.Time does not have a Century field.";
        throw new OperationNotSupportedException(err);
    }

    public void setCentury(short century) {
        String err = "org.exolab.castor.types.Time does not have a Century field.";
        throw new OperationNotSupportedException(err);
    }

    public boolean hasYear() {
        return false;
    }

    public short getYear() {
        String err = "org.exolab.castor.types.Time does not have a Year field.";
        throw new OperationNotSupportedException(err);
    }

    public void setYear(short year) {
        String err = "org.exolab.castor.types.Time does not have a Year field.";
        throw new OperationNotSupportedException(err);
    }

    public boolean hasMonth() {
        return false;
    }

    public short getMonth() {
        String err = "org.exolab.castor.types.Time does not have a Month field.";
        throw new OperationNotSupportedException(err);
    }

    public void setMonth(short month) {
        String err = "org.exolab.castor.types.Time does not have a Month field.";
        throw new OperationNotSupportedException(err);
    }

    public boolean hasDay() {
        return false;
    }

    public short getDay() {
        String err = "org.exolab.castor.types.Time does not have a Day field.";
        throw new OperationNotSupportedException(err);
    }

    public void setDay(short month) {
        String err = "org.exolab.castor.types.Time does not have a Day field.";
        throw new OperationNotSupportedException(err);
    }
}

